"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChatExperience = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _managementSettingsComponentsFieldRow = require("@kbn/management-settings-components-field-row");
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _aiAssistantCommon = require("@kbn/ai-assistant-common");
var _i18nReact = require("@kbn/i18n-react");
var _telemetry = require("@kbn/onechat-common/telemetry");
var _ai_agent_confirmation_modal = require("@kbn/ai-agent-confirmation-modal/ai_agent_confirmation_modal");
var _settings_context = require("../../contexts/settings_context");
var _use_kibana = require("../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/gen_ai_settings/public/components/chat_experience/chat_experience.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TELEMETRY_SOURCE = 'stack_management';
const SKIP_STEP_REACHED_ONCE_SESSION_STORAGE_KEY = 'gen_ai_settings:skip_step_reached_once';
const SKIP_STEP_REACHED_ONCE_TTL_MS = 30_000;
/**
 * Helper function to safely report telemetry events
 */
const reportTelemetryEvent = (analytics, eventType, payload) => {
  analytics === null || analytics === void 0 ? void 0 : analytics.reportEvent(eventType, payload);
};

/**
 * Type guard to check if a value is a valid AIChatExperience
 */
const isAIChatExperience = value => {
  return typeof value === 'string' && (value === _aiAssistantCommon.AIChatExperience.Classic || value === _aiAssistantCommon.AIChatExperience.Agent);
};
const consumeSkipStepReachedOnce = (storage = window.sessionStorage, key = SKIP_STEP_REACHED_ONCE_SESSION_STORAGE_KEY, now = Date.now()) => {
  try {
    const raw = storage.getItem(key);
    if (!raw) return false;
    // Always consume the flag if present to avoid it getting "stuck" and suppressing future visits.
    storage.removeItem(key);
    const ts = Number.parseInt(raw, 10);
    if (!Number.isFinite(ts)) return true;
    return now - ts < SKIP_STEP_REACHED_ONCE_TTL_MS;
  } catch {
    return false;
  }
};
const ChatExperience = () => {
  var _application$capabili;
  const {
    fields,
    handleFieldChange,
    unsavedChanges
  } = (0, _settings_context.useSettingsContext)();
  const {
    services: {
      settings,
      notifications,
      docLinks,
      application,
      analytics
    }
  } = (0, _use_kibana.useKibana)();
  const [isConfirmModalOpen, setConfirmModalOpen] = (0, _react.useState)(false);
  const field = fields[_managementSettingsIds.AI_CHAT_EXPERIENCE_TYPE];
  const canEditAdvancedSettings = Boolean((_application$capabili = application.capabilities.advancedSettings) === null || _application$capabili === void 0 ? void 0 : _application$capabili.save);
  const savedValue = isAIChatExperience(field === null || field === void 0 ? void 0 : field.savedValue) ? field.savedValue : undefined;
  const hasTrackedInitialStep = (0, _react.useRef)(false);
  (0, _react.useEffect)(() => {
    if (hasTrackedInitialStep.current) return;
    if (!field) return;
    // don’t track the opt-in step if the default experience is already Agent
    if (!savedValue && (field === null || field === void 0 ? void 0 : field.defaultValue) === 'agent') return;
    if (savedValue && savedValue !== 'classic') return;
    if (consumeSkipStepReachedOnce()) {
      hasTrackedInitialStep.current = true;
      return;
    }
    reportTelemetryEvent(analytics, _telemetry.AGENT_BUILDER_EVENT_TYPES.OptInAction, {
      action: 'step_reached',
      source: TELEMETRY_SOURCE
    });
    hasTrackedInitialStep.current = true;
  }, [analytics, field, savedValue]);

  // Show confirmation modal for AI Agents selection
  const wrappedHandleFieldChange = (0, _react.useCallback)((id, change) => {
    if (id === _managementSettingsIds.AI_CHAT_EXPERIENCE_TYPE) {
      const newValue = isAIChatExperience(change === null || change === void 0 ? void 0 : change.unsavedValue) ? change.unsavedValue : undefined;
      if (newValue === _aiAssistantCommon.AIChatExperience.Agent) {
        reportTelemetryEvent(analytics, _telemetry.AGENT_BUILDER_EVENT_TYPES.OptInAction, {
          action: 'confirmation_shown',
          source: TELEMETRY_SOURCE
        });
      }

      // Handle modal display logic
      if (newValue === _aiAssistantCommon.AIChatExperience.Agent) {
        setConfirmModalOpen(true);
      }
    }
    handleFieldChange(id, change);
  }, [handleFieldChange, analytics]);
  const handleConfirmAgent = (0, _react.useCallback)(() => {
    setConfirmModalOpen(false);
  }, []);
  const handleCancelAgent = (0, _react.useCallback)(() => {
    setConfirmModalOpen(false);
    reportTelemetryEvent(analytics, _telemetry.AGENT_BUILDER_EVENT_TYPES.OptInAction, {
      action: 'canceled',
      source: TELEMETRY_SOURCE
    });
    // Clear the unsaved change by passing undefined
    handleFieldChange(_managementSettingsIds.AI_CHAT_EXPERIENCE_TYPE, undefined);
  }, [handleFieldChange, analytics]);
  const description = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "aiAssistantManagementSelection.preferredChatExperienceSettingDescription",
    defaultMessage: "Choose which chat experience to use for everyone in this space. {learnMoreLink}",
    values: {
      learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.agentBuilder.learnMore,
        target: "_blank",
        "data-test-subj": "aiAgentBuilderLearnMoreLink",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 140,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "aiAssistantManagementSelection.preferredChatExperienceSettingDescription.learnMoreLink",
        defaultMessage: "Learn more",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 145,
          columnNumber: 15
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 7
    }
  }), [docLinks.links.agentBuilder.learnMore]);
  if (!field) {
    return null;
  }
  const fieldWithDescription = {
    ...field,
    description
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_managementSettingsComponentsFieldRow.FieldRowProvider, {
    links: docLinks.links.management,
    showDanger: message => notifications.toasts.addDanger(message),
    validateChange: (key, value) => settings.client.validateValue(key, value),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_managementSettingsComponentsFieldRow.FieldRow, {
    field: fieldWithDescription,
    isSavingEnabled: canEditAdvancedSettings,
    onFieldChange: wrappedHandleFieldChange,
    unsavedChange: unsavedChanges[_managementSettingsIds.AI_CHAT_EXPERIENCE_TYPE],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 9
    }
  })), isConfirmModalOpen && /*#__PURE__*/_react.default.createElement(_ai_agent_confirmation_modal.AIAgentConfirmationModal, {
    onConfirm: handleConfirmAgent,
    onCancel: handleCancelAgent,
    docLinks: docLinks.links,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 9
    }
  }));
};
exports.ChatExperience = ChatExperience;