"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerKbnClientSoRoutes = void 0;
var _bulk_delete = require("./bulk_delete");
var _create = require("./create");
var _delete = require("./delete");
var _find = require("./find");
var _get = require("./get");
var _update = require("./update");
var _clean = require("./clean");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const registerKbnClientSoRoutes = router => {
  (0, _bulk_delete.registerBulkDeleteRoute)(router);
  (0, _create.registerCreateRoute)(router);
  (0, _delete.registerDeleteRoute)(router);
  (0, _find.registerFindRoute)(router);
  (0, _get.registerGetRoute)(router);
  (0, _update.registerUpdateRoute)(router);
  (0, _clean.registerCleanRoute)(router);
};
exports.registerKbnClientSoRoutes = registerKbnClientSoRoutes;