"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdateCloudConnectorResponseSchema = exports.UpdateCloudConnectorRequestSchema = exports.GetCloudConnectorsResponseSchema = exports.GetCloudConnectorsRequestSchema = exports.GetCloudConnectorUsageResponseSchema = exports.GetCloudConnectorUsageRequestSchema = exports.GetCloudConnectorResponseSchema = exports.GetCloudConnectorRequestSchema = exports.DeleteCloudConnectorResponseSchema = exports.DeleteCloudConnectorRequestSchema = exports.CreateCloudConnectorResponseSchema = exports.CreateCloudConnectorRequestSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CreateCloudConnectorRequestSchema = exports.CreateCloudConnectorRequestSchema = {
  body: _configSchema.schema.object({
    name: _configSchema.schema.string({
      minLength: 1,
      maxLength: 255,
      meta: {
        description: 'The name of the cloud connector.'
      }
    }),
    cloudProvider: _configSchema.schema.oneOf([_configSchema.schema.literal('aws'), _configSchema.schema.literal('azure'), _configSchema.schema.literal('gcp')], {
      meta: {
        description: 'The cloud provider type: aws, azure, or gcp.'
      }
    }),
    accountType: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(_constants.SINGLE_ACCOUNT), _configSchema.schema.literal(_constants.ORGANIZATION_ACCOUNT)], {
      meta: {
        description: 'The account type: single-account (single account/subscription) or organization-account (organization-wide).'
      }
    })),
    vars: _configSchema.schema.recordOf(_configSchema.schema.string({
      minLength: 1,
      maxLength: 100
    }), _configSchema.schema.oneOf([_configSchema.schema.string({
      maxLength: 1000
    }), _configSchema.schema.number(), _configSchema.schema.boolean(), _configSchema.schema.object({
      type: _configSchema.schema.string({
        maxLength: 50
      }),
      value: _configSchema.schema.oneOf([_configSchema.schema.string({
        maxLength: 1000
      }), _configSchema.schema.object({
        isSecretRef: _configSchema.schema.boolean(),
        id: _configSchema.schema.string({
          maxLength: 255
        })
      })]),
      frozen: _configSchema.schema.maybe(_configSchema.schema.boolean())
    })]))
  })
};

// Schema for response vars - using recordOf for flexible OpenAPI generation
// The actual structure varies based on cloudProvider (AWS vs Azure), so we use a flexible schema
const CloudConnectorResponseVarsSchema = _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any());
const CreateCloudConnectorResponseSchema = exports.CreateCloudConnectorResponseSchema = _configSchema.schema.object({
  item: _configSchema.schema.object({
    id: _configSchema.schema.string(),
    name: _configSchema.schema.string(),
    namespace: _configSchema.schema.maybe(_configSchema.schema.string()),
    cloudProvider: _configSchema.schema.string(),
    accountType: _configSchema.schema.maybe(_configSchema.schema.string()),
    vars: CloudConnectorResponseVarsSchema,
    packagePolicyCount: _configSchema.schema.number(),
    created_at: _configSchema.schema.string(),
    updated_at: _configSchema.schema.string()
  })
});
const GetCloudConnectorsRequestSchema = exports.GetCloudConnectorsRequestSchema = {
  query: _configSchema.schema.object({
    page: _configSchema.schema.maybe(_configSchema.schema.string({
      meta: {
        description: 'The page number for pagination.'
      }
    })),
    perPage: _configSchema.schema.maybe(_configSchema.schema.string({
      meta: {
        description: 'The number of items per page.'
      }
    })),
    kuery: _configSchema.schema.maybe(_configSchema.schema.string({
      meta: {
        description: 'KQL query to filter cloud connectors.'
      }
    }))
  })
};
const GetCloudConnectorsResponseSchema = exports.GetCloudConnectorsResponseSchema = _configSchema.schema.object({
  items: _configSchema.schema.arrayOf(_configSchema.schema.object({
    id: _configSchema.schema.string(),
    name: _configSchema.schema.string(),
    namespace: _configSchema.schema.maybe(_configSchema.schema.string()),
    cloudProvider: _configSchema.schema.string(),
    accountType: _configSchema.schema.maybe(_configSchema.schema.string()),
    vars: CloudConnectorResponseVarsSchema,
    packagePolicyCount: _configSchema.schema.number(),
    created_at: _configSchema.schema.string(),
    updated_at: _configSchema.schema.string()
  }), {
    maxSize: 10000
  })
});
const GetCloudConnectorRequestSchema = exports.GetCloudConnectorRequestSchema = {
  params: _configSchema.schema.object({
    cloudConnectorId: _configSchema.schema.string({
      meta: {
        description: 'The unique identifier of the cloud connector.'
      }
    })
  })
};
const GetCloudConnectorResponseSchema = exports.GetCloudConnectorResponseSchema = _configSchema.schema.object({
  item: _configSchema.schema.object({
    id: _configSchema.schema.string(),
    name: _configSchema.schema.string(),
    namespace: _configSchema.schema.maybe(_configSchema.schema.string()),
    cloudProvider: _configSchema.schema.string(),
    accountType: _configSchema.schema.maybe(_configSchema.schema.string()),
    vars: CloudConnectorResponseVarsSchema,
    packagePolicyCount: _configSchema.schema.number(),
    created_at: _configSchema.schema.string(),
    updated_at: _configSchema.schema.string()
  })
});
const DeleteCloudConnectorRequestSchema = exports.DeleteCloudConnectorRequestSchema = {
  params: _configSchema.schema.object({
    cloudConnectorId: _configSchema.schema.string({
      meta: {
        description: 'The unique identifier of the cloud connector to delete.'
      }
    })
  }),
  query: _configSchema.schema.object({
    force: _configSchema.schema.maybe(_configSchema.schema.boolean({
      meta: {
        description: 'If true, forces deletion even if the cloud connector is in use.'
      }
    }))
  })
};
const DeleteCloudConnectorResponseSchema = exports.DeleteCloudConnectorResponseSchema = _configSchema.schema.object({
  id: _configSchema.schema.string()
});
const UpdateCloudConnectorRequestSchema = exports.UpdateCloudConnectorRequestSchema = {
  params: _configSchema.schema.object({
    cloudConnectorId: _configSchema.schema.string({
      meta: {
        description: 'The unique identifier of the cloud connector to update.'
      }
    })
  }),
  body: _configSchema.schema.object({
    name: _configSchema.schema.maybe(_configSchema.schema.string({
      minLength: 1,
      maxLength: 255,
      meta: {
        description: 'The name of the cloud connector.'
      }
    })),
    accountType: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(_constants.SINGLE_ACCOUNT), _configSchema.schema.literal(_constants.ORGANIZATION_ACCOUNT)], {
      meta: {
        description: 'The account type: single-account (single account/subscription) or organization-account (organization-wide).'
      }
    })),
    vars: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string({
      minLength: 1,
      maxLength: 100
    }), _configSchema.schema.oneOf([_configSchema.schema.string({
      maxLength: 1000
    }), _configSchema.schema.number(), _configSchema.schema.boolean(), _configSchema.schema.object({
      type: _configSchema.schema.string({
        maxLength: 50
      }),
      value: _configSchema.schema.oneOf([_configSchema.schema.string({
        maxLength: 1000
      }), _configSchema.schema.object({
        isSecretRef: _configSchema.schema.boolean(),
        id: _configSchema.schema.string({
          maxLength: 255
        })
      })]),
      frozen: _configSchema.schema.maybe(_configSchema.schema.boolean())
    })])))
  })
};
const UpdateCloudConnectorResponseSchema = exports.UpdateCloudConnectorResponseSchema = _configSchema.schema.object({
  item: _configSchema.schema.object({
    id: _configSchema.schema.string(),
    name: _configSchema.schema.string(),
    namespace: _configSchema.schema.maybe(_configSchema.schema.string()),
    cloudProvider: _configSchema.schema.string(),
    accountType: _configSchema.schema.maybe(_configSchema.schema.string()),
    vars: CloudConnectorResponseVarsSchema,
    packagePolicyCount: _configSchema.schema.number(),
    created_at: _configSchema.schema.string(),
    updated_at: _configSchema.schema.string()
  })
});
const GetCloudConnectorUsageRequestSchema = exports.GetCloudConnectorUsageRequestSchema = {
  params: _configSchema.schema.object({
    cloudConnectorId: _configSchema.schema.string({
      meta: {
        description: 'The unique identifier of the cloud connector.'
      }
    })
  }),
  query: _configSchema.schema.object({
    page: _configSchema.schema.maybe(_configSchema.schema.number({
      min: 1,
      meta: {
        description: 'The page number for pagination.'
      }
    })),
    perPage: _configSchema.schema.maybe(_configSchema.schema.number({
      min: 1,
      meta: {
        description: 'The number of items per page.'
      }
    }))
  })
};
const GetCloudConnectorUsageResponseSchema = exports.GetCloudConnectorUsageResponseSchema = _configSchema.schema.object({
  items: _configSchema.schema.arrayOf(_configSchema.schema.object({
    id: _configSchema.schema.string(),
    name: _configSchema.schema.string(),
    package: _configSchema.schema.maybe(_configSchema.schema.object({
      name: _configSchema.schema.string(),
      title: _configSchema.schema.string(),
      version: _configSchema.schema.string()
    })),
    policy_ids: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
      maxSize: 10000
    }),
    created_at: _configSchema.schema.string(),
    updated_at: _configSchema.schema.string()
  }), {
    maxSize: 10000
  }),
  total: _configSchema.schema.number(),
  page: _configSchema.schema.number(),
  perPage: _configSchema.schema.number()
});