"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerSetupTasks = registerSetupTasks;
var _services = require("../../services");
var _utils = require("./utils");
var _run_backport_package_policy_input_id = require("./run_backport_package_policy_input_id");
var _run_migrate_component_template_ilms = require("./run_migrate_component_template_ilms");
var _run_upgrade_package_install_version = require("./run_upgrade_package_install_version");
var _run_reinstall_packages_for_global_asset_update = require("./run_reinstall_packages_for_global_asset_update");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Register Fleet setup operations, migrations, ...
 */
function registerSetupTasks(taskManager) {
  taskManager.registerTaskDefinitions({
    [_utils.TASK_TYPE]: {
      title: _utils.TASK_TITLE,
      timeout: _utils.TASK_TIMEOUT,
      maxAttempts: 3,
      createTaskRunner: ({
        taskInstance,
        abortController
      }) => {
        const logger = _services.appContextService.getLogger();
        return {
          run: async () => {
            logger.debug(`Starting setup operation: ${taskInstance.params.type}`);
            const taskParams = taskInstance.params;
            try {
              if (taskParams.type === 'backportPackagePolicyInputId') {
                await (0, _run_backport_package_policy_input_id.runBackportPackagePolicyInputId)({
                  abortController,
                  logger
                });
              } else if (taskParams.type === 'migrateComponentTemplateILMs') {
                await (0, _run_migrate_component_template_ilms.runMigrateComponentTemplateILMs)({
                  abortController,
                  logger
                });
              } else if (taskParams.type === 'upgradePackageInstallVersion') {
                await (0, _run_upgrade_package_install_version.runUpgradePackageInstallVersion)({
                  abortController,
                  logger
                });
              } else if (taskParams.type === 'reinstallPackagesForGlobalAssetUpdate') {
                await (0, _run_reinstall_packages_for_global_asset_update.runReinstallPackagesForGlobalAssetUpdate)({
                  abortController,
                  logger
                });
              } else {
                throw new Error(`Unknown setup operation: ${taskParams.type}`);
              }
            } catch (error) {
              logger.error(`Fleet setup operation: ${taskParams.type} failed`, {
                error
              });
              throw error;
            }
          },
          cancel: async () => {
            logger.debug(`Fleet setup operations timed out: ${taskInstance.params.type}`);
          }
        };
      }
    }
  });
}