"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.scheduleSetupTask = scheduleSetupTask;
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_SETUP_TASKS = [{
  type: 'backportPackagePolicyInputId'
}, {
  type: 'migrateComponentTemplateILMs'
}];

/**
 * Schedule Fleet setup tasks.
 *
 * @param taskManagerStart - Task manager start contract
 * @param taskParams - Optional specific task to schedule. If not provided, schedules default setup tasks.
 */
async function scheduleSetupTask(taskManagerStart, taskParams) {
  const tasksToSchedule = taskParams ? [taskParams] : DEFAULT_SETUP_TASKS;
  for (let i = 0; i < tasksToSchedule.length; i++) {
    const params = tasksToSchedule[i];
    await taskManagerStart.ensureScheduled({
      id: `${_utils.TASK_TYPE}:${params.type}`,
      scope: ['fleet'],
      params,
      taskType: _utils.TASK_TYPE,
      // Stagger task execution by 3 seconds each
      runAt: new Date(Date.now() + (i + 1) * 3 * 1000),
      state: {}
    });
  }
}