"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.runUpgradePackageInstallVersion = runUpgradePackageInstallVersion;
var _pMap = _interopRequireDefault(require("p-map"));
var _services = require("../../services");
var _constants = require("../../constants");
var _fleet_es_assets = require("../../constants/fleet_es_assets");
var _packages = require("../../services/epm/packages");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Deferred task to upgrade package install versions for packages installed with an older version of Kibana.
 */
async function runUpgradePackageInstallVersion({
  abortController,
  logger
}) {
  var _config$startupOptimi, _config$startupOptimi2, _config$startupOptimi3, _config$startupOptimi4;
  const soClient = _services.appContextService.getInternalUserSOClientWithoutSpaceExtension();
  const esClient = _services.appContextService.getInternalUserESClient();
  const config = _services.appContextService.getConfig();
  const maxConcurrency = (_config$startupOptimi = config === null || config === void 0 ? void 0 : (_config$startupOptimi2 = config.startupOptimization) === null || _config$startupOptimi2 === void 0 ? void 0 : _config$startupOptimi2.maxConcurrentPackageOperations) !== null && _config$startupOptimi !== void 0 ? _config$startupOptimi : _constants.MAX_CONCURRENT_EPM_PACKAGES_INSTALLATIONS;
  const batchSize = (_config$startupOptimi3 = config === null || config === void 0 ? void 0 : (_config$startupOptimi4 = config.startupOptimization) === null || _config$startupOptimi4 === void 0 ? void 0 : _config$startupOptimi4.packageUpgradeBatchSize) !== null && _config$startupOptimi3 !== void 0 ? _config$startupOptimi3 : 50;
  logger.info('Starting deferred package install version upgrade');

  // Find outdated installations
  const res = await soClient.find({
    type: _constants.PACKAGES_SAVED_OBJECT_TYPE,
    perPage: _constants.SO_SEARCH_LIMIT,
    filter: `${_constants.PACKAGES_SAVED_OBJECT_TYPE}.attributes.install_status:installed and (${_constants.PACKAGES_SAVED_OBJECT_TYPE}.attributes.install_format_schema_version < ${_fleet_es_assets.FLEET_INSTALL_FORMAT_VERSION} or not ${_constants.PACKAGES_SAVED_OBJECT_TYPE}.attributes.install_format_schema_version:*)`
  });
  if (res.total === 0) {
    logger.debug('No packages require install version upgrade');
    return;
  }
  logger.info(`Found ${res.total} packages requiring install version upgrade`);
  const savedObjects = res.saved_objects;
  for (let i = 0; i < savedObjects.length; i += batchSize) {
    if (abortController.signal.aborted) {
      logger.warn('Package install version upgrade was aborted');
      return;
    }
    const batch = savedObjects.slice(i, i + batchSize);
    logger.debug(`Processing batch ${Math.floor(i / batchSize) + 1} of ${Math.ceil(savedObjects.length / batchSize)}`);
    await (0, _pMap.default)(batch, async ({
      attributes: installation
    }) => {
      if (abortController.signal.aborted) {
        return;
      }
      try {
        await (0, _packages.reinstallPackageForInstallation)({
          soClient,
          esClient,
          installation
        });
        logger.debug(`Successfully upgraded package install version for ${installation.name}`);
      } catch (err) {
        if (installation.install_source === 'upload') {
          logger.warn(`Uploaded package needs to be manually reinstalled ${installation.name}. ${err.message}`);
        } else {
          logger.error(`Package needs to be manually reinstalled ${installation.name} updating install_version failed. ${err.message}`);
        }
      }
    }, {
      concurrency: maxConcurrency
    });
  }
  logger.info('Completed deferred package install version upgrade');
}