"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerAgentlessDeploymentSyncTask = registerAgentlessDeploymentSyncTask;
exports.scheduleAgentlessDeploymentSyncTask = scheduleAgentlessDeploymentSyncTask;
var _services = require("../../services");
var _deployment_sync = require("../../services/agentless/deployment_sync");
var _agentless_agent = require("../../services/agents/agentless_agent");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TASK_TYPE = 'fleet:agentless-deployment-sync-task';
const TASK_TITLE = 'Fleet agentless deployment sync Task';
const TASK_TIMEOUT = '10m';
const TASK_ID = `${TASK_TYPE}:1.0.0`;
function registerAgentlessDeploymentSyncTask(taskManager, config) {
  taskManager.registerTaskDefinitions({
    [TASK_TYPE]: {
      title: TASK_TITLE,
      timeout: TASK_TIMEOUT,
      maxAttempts: 1,
      createTaskRunner: ({
        taskInstance,
        abortController
      }) => {
        const logger = _services.appContextService.getLogger().get('agentless');
        return {
          run: async () => {
            logger.debug(`Starting agentless deployment sync`);
            try {
              var _config$agentless, _config$agentless2, _config$agentless2$ba;
              await (0, _deployment_sync.syncAgentlessDeployments)({
                agentlessAgentService: _agentless_agent.agentlessAgentService,
                logger
              }, {
                dryRun: (config === null || config === void 0 ? void 0 : (_config$agentless = config.agentless) === null || _config$agentless === void 0 ? void 0 : _config$agentless.enabled) && (config === null || config === void 0 ? void 0 : (_config$agentless2 = config.agentless) === null || _config$agentless2 === void 0 ? void 0 : (_config$agentless2$ba = _config$agentless2.backgroundSync) === null || _config$agentless2$ba === void 0 ? void 0 : _config$agentless2$ba.dryRun),
                abortController
              });
            } catch (error) {
              logger.error(`agentless deployment sync failed`, {
                error
              });
              throw error;
            }
          },
          cancel: async () => {
            logger.debug(`Fleet agentless deployment sync timed out`);
          }
        };
      }
    }
  });
}
async function scheduleAgentlessDeploymentSyncTask(taskManager, config) {
  try {
    var _config$agentless3, _config$agentless4, _config$agentless4$ba, _config$agentless$bac, _config$agentless5, _config$agentless5$ba;
    await taskManager.ensureScheduled({
      id: TASK_ID,
      taskType: TASK_TYPE,
      enabled: (config === null || config === void 0 ? void 0 : (_config$agentless3 = config.agentless) === null || _config$agentless3 === void 0 ? void 0 : _config$agentless3.enabled) && (config === null || config === void 0 ? void 0 : (_config$agentless4 = config.agentless) === null || _config$agentless4 === void 0 ? void 0 : (_config$agentless4$ba = _config$agentless4.backgroundSync) === null || _config$agentless4$ba === void 0 ? void 0 : _config$agentless4$ba.enabled),
      schedule: {
        interval: (_config$agentless$bac = config === null || config === void 0 ? void 0 : (_config$agentless5 = config.agentless) === null || _config$agentless5 === void 0 ? void 0 : (_config$agentless5$ba = _config$agentless5.backgroundSync) === null || _config$agentless5$ba === void 0 ? void 0 : _config$agentless5$ba.interval) !== null && _config$agentless$bac !== void 0 ? _config$agentless$bac : '1h'
      },
      state: {},
      params: {}
    });
  } catch (error) {
    _services.appContextService.getLogger().error(`Error scheduling agentless deployment sync task.`, {
      error
    });
  }
}