"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isSSLSecretStorageEnabled = isSSLSecretStorageEnabled;
var _constants = require("../../constants");
var _fleet_server = require("../fleet_server");
var _ = require("..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function isSSLSecretStorageEnabled(esClient, soClient) {
  var _appContextService$ge, _appContextService$ge2, _appContextService$ge3;
  const logger = _.appContextService.getLogger();

  // if serverless then secrets will always be supported
  const isFleetServerStandalone = (_appContextService$ge = (_appContextService$ge2 = _.appContextService.getConfig()) === null || _appContextService$ge2 === void 0 ? void 0 : (_appContextService$ge3 = _appContextService$ge2.internal) === null || _appContextService$ge3 === void 0 ? void 0 : _appContextService$ge3.fleetServerStandalone) !== null && _appContextService$ge !== void 0 ? _appContextService$ge : false;
  if (isFleetServerStandalone) {
    logger.trace('SSL secrets storage is enabled as fleet server is standalone');
    return true;
  }

  // now check the flag in settings to see if the fleet server requirement has already been met
  // once the requirement has been met, secrets are always on
  const settings = await _.settingsService.getSettingsOrUndefined(soClient);
  if (settings && settings.ssl_secret_storage_requirements_met) {
    logger.debug('SSL secrets storage requirements already met, turned on in settings');
    return true;
  }

  // otherwise check if we have the minimum fleet server version and enable secrets if so
  if (await (0, _fleet_server.checkFleetServerVersionsForSecretsStorage)(esClient, soClient, _constants.SSL_SECRETS_MINIMUM_FLEET_SERVER_VERSION)) {
    logger.debug('Enabling SSL secrets storage as minimum fleet server version has been met');
    try {
      await _.settingsService.saveSettings(soClient, {
        ssl_secret_storage_requirements_met: true
      });
    } catch (err) {
      // we can suppress this error as it will be retried on the next function call
      logger.warn(`Failed to save settings after enabling SSL secrets storage: ${err.message}`);
    }
    return true;
  }
  logger.info('Secrets storage is disabled as minimum fleet server version has not been met');
  return false;
}