"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIntegrationKnowledgeSetting = getIntegrationKnowledgeSetting;
var _app_context = require("../../app_context");
var _settings = require("../../settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getIntegrationKnowledgeSetting(savedObjectsClient) {
  var _config$experimentalF, _config$experimentalF2;
  const config = _app_context.appContextService.getConfig();
  const integrationKnowledgeConfig = (_config$experimentalF = config === null || config === void 0 ? void 0 : (_config$experimentalF2 = config.experimentalFeatures) === null || _config$experimentalF2 === void 0 ? void 0 : _config$experimentalF2.integrationKnowledge) !== null && _config$experimentalF !== void 0 ? _config$experimentalF : _app_context.appContextService.getExperimentalFeatures().installIntegrationsKnowledge;
  try {
    const {
      integration_knowledge_enabled: integrationKnowledgeEnabled
    } = await (0, _settings.getSettings)(savedObjectsClient);
    return integrationKnowledgeEnabled !== null && integrationKnowledgeEnabled !== void 0 ? integrationKnowledgeEnabled : integrationKnowledgeConfig;
  } catch (err) {
    _app_context.appContextService.getLogger().warn('Error while trying to load integration knowledge flag from settings, defaulting to feature flag', err);
  }
  return integrationKnowledgeConfig;
}