"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.packagePolicyV13AdvancedFields = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const packagePolicyV13AdvancedFields = packagePolicyDoc => {
  var _packagePolicyDoc$att;
  if (((_packagePolicyDoc$att = packagePolicyDoc.attributes.package) === null || _packagePolicyDoc$att === void 0 ? void 0 : _packagePolicyDoc$att.name) !== 'endpoint') {
    return {
      attributes: packagePolicyDoc.attributes
    };
  }
  const updatedPackagePolicyDoc = packagePolicyDoc;
  const input = updatedPackagePolicyDoc.attributes.inputs[0];
  if (input && input.config) {
    var _policy$windows$advan, _policy$linux$advance, _policy$mac$advanced;
    const policy = input.config.policy.value;
    policy.windows.advanced = {
      ...policy.windows.advanced,
      events: {
        deduplicate_network_events: false,
        process_ancestry_length: 20,
        ancestry_in_all_events: true,
        ...((_policy$windows$advan = policy.windows.advanced) === null || _policy$windows$advan === void 0 ? void 0 : _policy$windows$advan.events)
      }
    };
    policy.linux.advanced = {
      ...policy.linux.advanced,
      events: {
        deduplicate_network_events: false,
        process_ancestry_length: 20,
        ancestry_in_all_events: true,
        ...((_policy$linux$advance = policy.linux.advanced) === null || _policy$linux$advance === void 0 ? void 0 : _policy$linux$advance.events)
      }
    };
    policy.mac.advanced = {
      ...policy.mac.advanced,
      events: {
        deduplicate_network_events: false,
        process_ancestry_length: 20,
        ancestry_in_all_events: true,
        ...((_policy$mac$advanced = policy.mac.advanced) === null || _policy$mac$advanced === void 0 ? void 0 : _policy$mac$advanced.events)
      }
    };
  }
  return {
    attributes: updatedPackagePolicyDoc.attributes
  };
};
exports.packagePolicyV13AdvancedFields = packagePolicyV13AdvancedFields;