"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ListResponseSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ListResponseSchema = itemSchema => _configSchema.schema.object({
  items: _configSchema.schema.arrayOf(itemSchema, {
    maxSize: 10000
  }),
  total: _configSchema.schema.number(),
  page: _configSchema.schema.number(),
  perPage: _configSchema.schema.number()
});
exports.ListResponseSchema = ListResponseSchema;