"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createStartServices = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _mocks = require("@kbn/core/public/mocks");
var _public = require("@kbn/kibana-utils-plugin/public");
var _use_request = require("../hooks/use_request");
var _plugin_dependencies = require("./plugin_dependencies");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/mock/fleet_start_services.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// Taken from core. See: src/plugins/kibana_utils/public/storage/storage.test.ts
const createMockStore = () => {
  let store = {};
  return {
    getItem: jest.fn().mockImplementation(key => store[key]),
    setItem: jest.fn().mockImplementation((key, value) => store[key] = value),
    removeItem: jest.fn().mockImplementation(key => delete store[key]),
    clear: jest.fn().mockImplementation(() => store = {})
  };
};
const fleetAuthzMock = {
  fleet: {
    all: true,
    setup: true,
    readEnrollmentTokens: true,
    readAgentPolicies: true,
    readAgents: true,
    readSettings: true,
    allAgentPolicies: true,
    allAgents: true,
    allSettings: true,
    addAgents: true,
    addFleetServers: true
  },
  integrations: {
    all: true,
    readPackageInfo: true,
    readInstalledPackages: true,
    installPackages: true,
    upgradePackages: true,
    uploadPackages: true,
    removePackages: true,
    readPackageSettings: true,
    writePackageSettings: true,
    readIntegrationPolicies: true,
    writeIntegrationPolicies: true
  }
};
const configureStartServices = services => {
  // Store the http for use by useRequest
  (0, _use_request.setHttpClient)(services.http);

  // Set Fleet and Integrations capabilities
  services.application.capabilities = {
    ...services.application.capabilities,
    // Fleet
    fleetv2: {
      read: true,
      all: true
    },
    // Integration
    fleet: {
      read: true,
      all: true
    }
  };

  // Setup the `i18n.Context` component
  services.i18n.Context.mockImplementation(({
    children
  }) => /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 5
    }
  }, children));
};
const createStartServices = (basePath = '/mock') => {
  const {
    cloud: cloudStart,
    ...startDeps
  } = (0, _plugin_dependencies.createStartDepsMock)();
  const {
    cloud: cloudSetup
  } = (0, _plugin_dependencies.createSetupDepsMock)();
  const startServices = {
    ..._mocks.coreMock.createStart({
      basePath
    }),
    ...startDeps,
    cloud: {
      ...cloudStart,
      ...cloudSetup
    },
    dashboard: {},
    storage: new _public.Storage(createMockStore()),
    authz: fleetAuthzMock
  };
  configureStartServices(startServices);
  return startServices;
};
exports.createStartServices = createStartServices;