"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sendBulkChangeAgentPrivilegeLevel = sendBulkChangeAgentPrivilegeLevel;
exports.sendBulkMigrateAgents = sendBulkMigrateAgents;
exports.sendChangeAgentPrivilegeLevel = sendChangeAgentPrivilegeLevel;
exports.sendDeleteAgentUpload = sendDeleteAgentUpload;
exports.sendGetActionStatus = sendGetActionStatus;
exports.sendGetAgentIncomingData = sendGetAgentIncomingData;
exports.sendGetAgentStatus = sendGetAgentStatus;
exports.sendGetAgentStatusRuntimeField = sendGetAgentStatusRuntimeField;
exports.sendGetAgentTagsForRq = sendGetAgentTagsForRq;
exports.sendGetAgentUploads = sendGetAgentUploads;
exports.sendGetAgents = sendGetAgents;
exports.sendGetAgentsAvailableVersions = sendGetAgentsAvailableVersions;
exports.sendGetAgentsForRq = sendGetAgentsForRq;
exports.sendMigrateSingleAgent = sendMigrateSingleAgent;
exports.sendPostAgentAction = sendPostAgentAction;
exports.sendPostAgentReassign = sendPostAgentReassign;
exports.sendPostAgentRollback = sendPostAgentRollback;
exports.sendPostAgentUnenroll = sendPostAgentUnenroll;
exports.sendPostAgentUpgrade = sendPostAgentUpgrade;
exports.sendPostBulkAgentReassign = sendPostBulkAgentReassign;
exports.sendPostBulkAgentRollback = sendPostBulkAgentRollback;
exports.sendPostBulkAgentTagsUpdate = sendPostBulkAgentTagsUpdate;
exports.sendPostBulkAgentUnenroll = sendPostBulkAgentUnenroll;
exports.sendPostBulkAgentUpgrade = sendPostBulkAgentUpgrade;
exports.sendPostBulkRequestDiagnostics = sendPostBulkRequestDiagnostics;
exports.sendPostCancelAction = sendPostCancelAction;
exports.sendPostRequestDiagnostics = sendPostRequestDiagnostics;
exports.sendPostRetrieveAgentsByActions = sendPostRetrieveAgentsByActions;
exports.sendPutAgentTagsUpdate = sendPutAgentTagsUpdate;
exports.useGetAgentStatus = useGetAgentStatus;
exports.useGetAgentStatusRuntimeFieldQuery = useGetAgentStatusRuntimeFieldQuery;
exports.useGetAgentUploads = void 0;
exports.useGetAgents = useGetAgents;
exports.useGetAgentsAvailableVersionsQuery = useGetAgentsAvailableVersionsQuery;
exports.useGetAgentsQuery = useGetAgentsQuery;
exports.useGetOneAgent = useGetOneAgent;
var _reactQuery = require("@kbn/react-query");
var _constants = require("../../../common/constants");
var _services = require("../../services");
var _use_request = require("./use_request");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useGetOneAgent(agentId, options) {
  return (0, _use_request.useRequest)({
    path: _services.agentRouteService.getInfoPath(agentId),
    method: 'get',
    version: _constants.API_VERSIONS.public.v1,
    ...options
  });
}
function useGetAgents(query, options) {
  return (0, _use_request.useRequest)({
    method: 'get',
    path: _services.agentRouteService.getListPath(),
    version: _constants.API_VERSIONS.public.v1,
    query,
    ...options
  });
}
function useGetAgentsQuery(query, options = {}) {
  return (0, _reactQuery.useQuery)(['agents', query], () => sendGetAgents(query), {
    enabled: options.enabled
  });
}

/**
 * @deprecated use sendGetAgentsForRq or useGetAgentsQuery instead
 */
function sendGetAgents(query, options) {
  return (0, _use_request.sendRequest)({
    method: 'get',
    path: _services.agentRouteService.getListPath(),
    version: _constants.API_VERSIONS.public.v1,
    query,
    ...options
  });
}
function sendGetAgentsForRq(query, options) {
  return (0, _use_request.sendRequestForRq)({
    method: 'get',
    path: _services.agentRouteService.getListPath(),
    version: _constants.API_VERSIONS.public.v1,
    query,
    ...options
  });
}
function useGetAgentStatus(query, options) {
  return (0, _use_request.useRequest)({
    method: 'get',
    path: _services.agentRouteService.getStatusPath(),
    version: _constants.API_VERSIONS.public.v1,
    query,
    ...options
  });
}
function sendGetAgentIncomingData(query) {
  return (0, _use_request.sendRequest)({
    method: 'get',
    path: _services.agentRouteService.getIncomingDataPath(),
    query,
    version: _constants.API_VERSIONS.public.v1
  });
}
function sendGetAgentStatus(query, options) {
  return (0, _use_request.sendRequest)({
    method: 'get',
    path: _services.agentRouteService.getStatusPath(),
    query,
    version: _constants.API_VERSIONS.public.v1,
    ...options
  });
}
function sendGetAgentTagsForRq(query, options) {
  return (0, _use_request.sendRequestForRq)({
    method: 'get',
    path: _services.agentRouteService.getListTagsPath(),
    query,
    version: _constants.API_VERSIONS.public.v1,
    ...options
  });
}
function sendPostAgentReassign(agentId, body, options) {
  return (0, _use_request.sendRequest)({
    method: 'post',
    path: _services.agentRouteService.getReassignPath(agentId),
    body,
    version: _constants.API_VERSIONS.public.v1,
    ...options
  });
}
function sendPostBulkAgentReassign(body, options) {
  return (0, _use_request.sendRequest)({
    method: 'post',
    path: _services.agentRouteService.getBulkReassignPath(),
    body,
    version: _constants.API_VERSIONS.public.v1,
    ...options
  });
}
function sendPostAgentUnenroll(agentId, body, options) {
  return (0, _use_request.sendRequest)({
    path: _services.agentRouteService.getUnenrollPath(agentId),
    method: 'post',
    body,
    version: _constants.API_VERSIONS.public.v1,
    ...options
  });
}
function sendPostBulkAgentUnenroll(body, options) {
  return (0, _use_request.sendRequest)({
    path: _services.agentRouteService.getBulkUnenrollPath(),
    method: 'post',
    body,
    version: _constants.API_VERSIONS.public.v1,
    ...options
  });
}
function sendPostAgentUpgrade(agentId, body, options) {
  return (0, _use_request.sendRequest)({
    path: _services.agentRouteService.getUpgradePath(agentId),
    method: 'post',
    body,
    version: _constants.API_VERSIONS.public.v1,
    ...options
  });
}
function sendPostRequestDiagnostics(agentId, body, options) {
  return (0, _use_request.sendRequest)({
    path: _services.agentRouteService.getRequestDiagnosticsPath(agentId),
    method: 'post',
    body,
    version: _constants.API_VERSIONS.public.v1,
    ...options
  });
}
function sendPostBulkRequestDiagnostics(body, options) {
  return (0, _use_request.sendRequest)({
    path: _services.agentRouteService.getBulkRequestDiagnosticsPath(),
    method: 'post',
    body,
    version: _constants.API_VERSIONS.public.v1,
    ...options
  });
}
function sendGetAgentUploads(agentId, options) {
  return (0, _use_request.sendRequest)({
    path: _services.agentRouteService.getListAgentUploads(agentId),
    method: 'get',
    version: _constants.API_VERSIONS.public.v1,
    ...options
  });
}
function sendDeleteAgentUpload(fileId, options) {
  return (0, _use_request.sendRequest)({
    path: _services.agentRouteService.getAgentFileDeletePath(fileId),
    method: 'delete',
    version: _constants.API_VERSIONS.public.v1,
    ...options
  });
}
const useGetAgentUploads = (agentId, options) => {
  return (0, _use_request.useRequest)({
    path: _services.agentRouteService.getListAgentUploads(agentId),
    method: 'get',
    version: _constants.API_VERSIONS.public.v1,
    ...options
  });
};
exports.useGetAgentUploads = useGetAgentUploads;
function sendPostAgentAction(agentId, body, options) {
  return (0, _use_request.sendRequest)({
    path: _services.agentRouteService.getCreateActionPath(agentId),
    method: 'post',
    body,
    version: _constants.API_VERSIONS.public.v1,
    ...options
  });
}
function sendPostBulkAgentUpgrade(body, options) {
  return (0, _use_request.sendRequest)({
    path: _services.agentRouteService.getBulkUpgradePath(),
    method: 'post',
    body,
    version: _constants.API_VERSIONS.public.v1,
    ...options
  });
}
function sendGetActionStatus(query = {}) {
  return (0, _use_request.sendRequest)({
    path: _services.agentRouteService.getActionStatusPath(),
    method: 'get',
    version: _constants.API_VERSIONS.public.v1,
    query
  });
}
function sendPostCancelAction(actionId) {
  return (0, _use_request.sendRequest)({
    path: _services.agentRouteService.getCancelActionPath(actionId),
    method: 'post',
    version: _constants.API_VERSIONS.public.v1
  });
}
function sendPostRetrieveAgentsByActions(body) {
  return (0, _use_request.sendRequest)({
    path: _services.agentRouteService.getAgentsByActionsPath(),
    method: 'post',
    version: _constants.API_VERSIONS.public.v1,
    body
  });
}
function sendPutAgentTagsUpdate(agentId, body, options) {
  return (0, _use_request.sendRequest)({
    method: 'put',
    path: _services.agentRouteService.getUpdatePath(agentId),
    body,
    version: _constants.API_VERSIONS.public.v1,
    ...options
  });
}
function sendPostBulkAgentTagsUpdate(body, options) {
  return (0, _use_request.sendRequest)({
    method: 'post',
    path: _services.agentRouteService.getBulkUpdateTagsPath(),
    body,
    version: _constants.API_VERSIONS.public.v1,
    ...options
  });
}
function sendGetAgentsAvailableVersions() {
  return (0, _use_request.sendRequest)({
    method: 'get',
    path: _services.agentRouteService.getAvailableVersionsPath(),
    version: _constants.API_VERSIONS.public.v1
  });
}
function useGetAgentsAvailableVersionsQuery(options = {}) {
  return (0, _reactQuery.useQuery)(['available_versions'], () => (0, _use_request.sendRequestForRq)({
    method: 'get',
    path: _services.agentRouteService.getAvailableVersionsPath(),
    version: _constants.API_VERSIONS.public.v1
  }), {
    enabled: options.enabled
  });
}
function sendGetAgentStatusRuntimeField() {
  return (0, _use_request.sendRequestForRq)({
    method: 'get',
    path: '/internal/fleet/agents/status_runtime_field',
    version: _constants.API_VERSIONS.internal.v1
  });
}
function useGetAgentStatusRuntimeFieldQuery(options = {}) {
  return (0, _reactQuery.useQuery)(['status_runtime_field'], () => sendGetAgentStatusRuntimeField(), {
    enabled: options.enabled
  });
}
function sendMigrateSingleAgent(options) {
  var _options$settings;
  return (0, _use_request.sendRequestForRq)({
    path: _services.agentRouteService.postMigrateSingleAgent(options.id),
    method: 'post',
    version: _constants.API_VERSIONS.public.v1,
    body: {
      enrollment_token: options.enrollment_token,
      uri: options.uri,
      settings: (_options$settings = options.settings) !== null && _options$settings !== void 0 ? _options$settings : {}
    }
  });
}
function sendBulkMigrateAgents(options) {
  var _options$settings2;
  return (0, _use_request.sendRequestForRq)({
    path: _services.agentRouteService.postBulkMigrateAgents(),
    method: 'post',
    version: _constants.API_VERSIONS.public.v1,
    body: {
      agents: options.agents,
      uri: options.uri,
      enrollment_token: options.enrollment_token,
      settings: (_options$settings2 = options.settings) !== null && _options$settings2 !== void 0 ? _options$settings2 : {}
    }
  });
}
function sendChangeAgentPrivilegeLevel(request) {
  return (0, _use_request.sendRequestForRq)({
    path: _services.agentRouteService.postChangeAgentPrivilegeLevel(request.agentId),
    method: 'post',
    version: _constants.API_VERSIONS.public.v1,
    body: request.body
  });
}
function sendBulkChangeAgentPrivilegeLevel(request) {
  return (0, _use_request.sendRequestForRq)({
    path: _services.agentRouteService.postBulkChangeAgentPrivilegeLevel(),
    method: 'post',
    version: _constants.API_VERSIONS.public.v1,
    body: request.body
  });
}
function sendPostAgentRollback(agentId) {
  return (0, _use_request.sendRequestForRq)({
    path: _services.agentRouteService.postAgentRollback(agentId),
    method: 'post',
    version: _constants.API_VERSIONS.public.v1
  });
}
function sendPostBulkAgentRollback(body) {
  return (0, _use_request.sendRequestForRq)({
    path: _services.agentRouteService.postBulkAgentRollback(),
    method: 'post',
    version: _constants.API_VERSIONS.public.v1,
    body
  });
}