"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PAGE_SIZE_OPTIONS = void 0;
exports.usePagination = usePagination;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PAGE_SIZE_OPTIONS = exports.PAGE_SIZE_OPTIONS = [5, 20, 50];
function usePagination(pageInfo = {
  currentPage: 1,
  pageSize: 20
}) {
  const [pagination, setPagination] = (0, _react.useState)(pageInfo);
  const pageSizeOptions = (0, _react.useMemo)(() => [...PAGE_SIZE_OPTIONS], []);
  return {
    pagination,
    setPagination,
    pageSizeOptions
  };
}