"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InstallationModeSelectionStep = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/components/agent_enrollment_flyout/steps/installation_mode_selection_step.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const PermissionWrapper = ({
  children,
  showTooltip
}) => {
  return showTooltip && children ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentFlyout.standaloneMissingPermissions",
      defaultMessage: "Read access to Agent Policies is required to see the standalone instructions.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 26,
        columnNumber: 9
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 5
    }
  }, children) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
};
const InstallationModeSelectionStep = ({
  selectedPolicyId,
  mode,
  setMode
}) => {
  const authz = (0, _hooks.useAuthz)();
  // radio id has to be unique so that the component works even if appears twice in DOM
  const radioSuffix = 'installation_mode_agent_selection';
  const onChangeCallback = v => {
    const value = v.split('_')[0];
    if (value === 'managed' || value === 'standalone') {
      setMode(value);
    }
  };
  return {
    status: selectedPolicyId ? undefined : 'disabled',
    title: _i18n.i18n.translate('xpack.fleet.agentEnrollment.stepInstallType', {
      defaultMessage: 'Enroll in Fleet?'
    }),
    children: selectedPolicyId ? /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
      options: [{
        id: `managed_${radioSuffix}`,
        'data-test-subj': 'agentFlyoutManagedRadioButtons',
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.agentFlyout.managedRadioOption",
          defaultMessage: "{managed} \u2013 Enroll in Elastic Agent in Fleet to automatically deploy updates and centrally manage the agent.",
          values: {
            managed: /*#__PURE__*/_react.default.createElement("strong", {
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 76,
                columnNumber: 21
              }
            }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.fleet.agentFlyout.managedMessage",
              defaultMessage: "Enroll in Fleet (recommended)",
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 77,
                columnNumber: 23
              }
            }))
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 71,
            columnNumber: 15
          }
        })
      }, {
        id: `standalone_${radioSuffix}`,
        // Disabled if no agentPolicies read permission
        disabled: !authz.fleet.readAgentPolicies,
        label: /*#__PURE__*/_react.default.createElement(PermissionWrapper, {
          showTooltip: !authz.fleet.readAgentPolicies,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 92,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          "data-test-subj": "agentFlyoutStandaloneRadioButtons",
          id: "xpack.fleet.agentFlyout.standaloneRadioOption",
          defaultMessage: "{standaloneMessage} \u2013 Run an Elastic Agent standalone to configure and update the agent manually on the host where the agent is installed.",
          values: {
            standaloneMessage: /*#__PURE__*/_react.default.createElement("strong", {
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 99,
                columnNumber: 23
              }
            }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.fleet.agentFlyout.standaloneMessage",
              defaultMessage: "Run standalone",
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 100,
                columnNumber: 25
              }
            }))
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 93,
            columnNumber: 17
          }
        }))
      }],
      idSelected: `${mode}_${radioSuffix}`,
      onChange: onChangeCallback,
      name: `installationMode${radioSuffix}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 7
      }
    }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 7
      }
    })
  };
};
exports.InstallationModeSelectionStep = InstallationModeSelectionStep;