"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRollbackAvailablePackages = exports.isRollbackTTLExpired = exports.isInstalledFromRegistry = exports.hasPreviousVersion = exports.checkRollbackAvailability = void 0;
var _react = require("react");
var _hooks = require("../../../../../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const hasPreviousVersion = item => {
  var _item$installationInf;
  return !!((_item$installationInf = item.installationInfo) !== null && _item$installationInf !== void 0 && _item$installationInf.previous_version);
};
exports.hasPreviousVersion = hasPreviousVersion;
const isRollbackTTLExpired = item => {
  var _item$installationInf2;
  return !!((_item$installationInf2 = item.installationInfo) !== null && _item$installationInf2 !== void 0 && _item$installationInf2.is_rollback_ttl_expired);
};
exports.isRollbackTTLExpired = isRollbackTTLExpired;
const isInstalledFromRegistry = item => {
  var _item$installationInf3;
  return ((_item$installationInf3 = item.installationInfo) === null || _item$installationInf3 === void 0 ? void 0 : _item$installationInf3.install_source) === 'registry';
};
exports.isInstalledFromRegistry = isInstalledFromRegistry;
const checkRollbackAvailability = (item, licenseService, isAvailableBackendCheck) => {
  return hasPreviousVersion(item) && !!licenseService.isEnterprise() && !isRollbackTTLExpired(item) && isInstalledFromRegistry(item) && isAvailableBackendCheck;
};
exports.checkRollbackAvailability = checkRollbackAvailability;
const useRollbackAvailablePackages = items => {
  const licenseService = (0, _hooks.useLicense)();
  const rollbackAvailablePackages = (0, _hooks.useGetBulkRollbackAvailableCheck)();
  return (0, _react.useMemo)(() => {
    const isRollbackAvailablePackages = {};
    items.forEach(item => {
      var _rollbackAvailablePac, _rollbackAvailablePac2;
      isRollbackAvailablePackages[item.name] = checkRollbackAvailability(item, licenseService, (_rollbackAvailablePac = (_rollbackAvailablePac2 = rollbackAvailablePackages[item.name]) === null || _rollbackAvailablePac2 === void 0 ? void 0 : _rollbackAvailablePac2.isAvailable) !== null && _rollbackAvailablePac !== void 0 ? _rollbackAvailablePac : false);
    });
    return isRollbackAvailablePackages;
  }, [items, licenseService, rollbackAvailablePackages]);
};
exports.useRollbackAvailablePackages = useRollbackAvailablePackages;