"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InstallationVersionStatus = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../../../../../hooks");
var _use_installed_integrations_actions = require("../hooks/use_installed_integrations_actions");
var _disabled_wrapper_tooltip = require("./disabled_wrapper_tooltip");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/screens/installed_integrations/components/installation_version_status.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const InstalledVersionStatus = /*#__PURE__*/_react.default.memo(({
  item
}) => {
  var _item$installationInf, _item$installationInf2;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "m",
    type: "checkInCircleFilled",
    color: "success",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  }, (_item$installationInf = (_item$installationInf2 = item.installationInfo) === null || _item$installationInf2 === void 0 ? void 0 : _item$installationInf2.version) !== null && _item$installationInf !== void 0 ? _item$installationInf : item.version));
});
const UpgradeAvailableVersionStatus = /*#__PURE__*/_react.default.memo(({
  item
}) => {
  const authz = (0, _hooks.useAuthz)();
  const isDisabled = !authz.integrations.upgradePackages;
  const {
    actions: {
      bulkUpgradeIntegrationsWithConfirmModal
    }
  } = (0, _use_installed_integrations_actions.useInstalledIntegrationsActions)();
  return /*#__PURE__*/_react.default.createElement(_disabled_wrapper_tooltip.DisabledWrapperTooltip, {
    tooltipContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epmInstalledIntegrations.upgradeRequiredPermissionTooltip",
      defaultMessage: "You don't have permissions to upgrade. Contact your administrator.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 9
      }
    }),
    disabled: isDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    iconType: "gear",
    flush: "left",
    onClick: () => {
      bulkUpgradeIntegrationsWithConfirmModal([item]);
    },
    disabled: isDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epmInstalledIntegrations.upgradeAvailableButton",
    defaultMessage: "Upgrade to {version}",
    values: {
      version: item.version
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 9
    }
  })));
});
const UpgradingVersionStatus = /*#__PURE__*/_react.default.memo(({
  item
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epmInstalledIntegrations.upgradingTooltip",
      defaultMessage: 'Upgrading to {version}',
      values: {
        version: item.version
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 9
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: 'm',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epmInstalledIntegrations.upgradingText",
    defaultMessage: "Upgrading...",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 11
    }
  }))));
});
const UninstallingVersionStatus = /*#__PURE__*/_react.default.memo(({
  item
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: 'm',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epmInstalledIntegrations.uninstallingText",
    defaultMessage: "Uninstalling...",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 9
    }
  })));
});
function formatAttempt(attempt) {
  var _attempt$error, _attempt$error2;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.packageCard.faileAttemptDescription",
    defaultMessage: "Failed at {attemptDate}.",
    values: {
      attemptDate: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedDate, {
        value: attempt.created_at,
        year: "numeric",
        month: "short",
        day: "numeric",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 136,
          columnNumber: 15
        }
      }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, " @ "), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedTime, {
        value: attempt.created_at,
        hour: "numeric",
        minute: "numeric",
        second: "numeric",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 143,
          columnNumber: 15
        }
      }))
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 7
    }
  }, ((_attempt$error = attempt.error) === null || _attempt$error === void 0 ? void 0 : _attempt$error.name) || '', " : ", ((_attempt$error2 = attempt.error) === null || _attempt$error2 === void 0 ? void 0 : _attempt$error2.message) || ''));
}
const InstallUpgradeFailedVersionStatus = /*#__PURE__*/_react.default.memo(({
  item,
  isUpgradeFailed
}) => {
  var _item$installationInf3, _item$installationInf4;
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  //  TODO handle failed install too
  // TODO permissions check and tooltip

  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    flush: "left",
    onClick: () => setIsPopoverOpen(currentVal => !currentVal),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "m",
    type: "error",
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 9
    }
  }, isUpgradeFailed ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epmInstalledIntegrations.statusUpgradeFailedLabel",
    defaultMessage: "Upgrade failed",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epmInstalledIntegrations.statusInstallFailedLabel",
    defaultMessage: "Install failed",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 13
    }
  }))));
  const latestAttempt = (_item$installationInf3 = item.installationInfo) === null || _item$installationInf3 === void 0 ? void 0 : (_item$installationInf4 = _item$installationInf3.latest_install_failed_attempts) === null || _item$installationInf4 === void 0 ? void 0 : _item$installationInf4[0];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    css: {
      maxWidth: 400
    },
    color: "danger",
    title: isUpgradeFailed ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epmInstalledIntegrations.statusUpgradeFailedLabel",
      defaultMessage: "Upgrade to {version } failed",
      values: {
        version: latestAttempt === null || latestAttempt === void 0 ? void 0 : latestAttempt.target_version
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 204,
        columnNumber: 13
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epmInstalledIntegrations.statusInstallFailedLabel",
      defaultMessage: "Install failed",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 212,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 7
    }
  }, latestAttempt ? formatAttempt(latestAttempt) : null, isUpgradeFailed &&
  /*#__PURE__*/
  // TODO Implement on click https://github.com/elastic/kibana/issues/209867
  _react.default.createElement(_eui.EuiButton, {
    color: "danger",
    fill: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epmInstalledIntegrations.retryUpgradeButtonLabel",
    defaultMessage: "Retry Upgrade",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 13
    }
  }))));
});
const InstallationVersionStatus = exports.InstallationVersionStatus = /*#__PURE__*/_react.default.memo(({
  item
}) => {
  const status = item.ui.installation_status;
  if (status === 'installed') {
    return /*#__PURE__*/_react.default.createElement(InstalledVersionStatus, {
      item: item,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 240,
        columnNumber: 12
      }
    });
  } else if (status === 'upgrade_available') {
    return /*#__PURE__*/_react.default.createElement(UpgradeAvailableVersionStatus, {
      item: item,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 242,
        columnNumber: 12
      }
    });
  } else if (status === 'upgrading') {
    return /*#__PURE__*/_react.default.createElement(UpgradingVersionStatus, {
      item: item,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 244,
        columnNumber: 12
      }
    });
  } else if (status === 'uninstalling') {
    return /*#__PURE__*/_react.default.createElement(UninstallingVersionStatus, {
      item: item,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 246,
        columnNumber: 12
      }
    });
  } else if (status === 'upgrade_failed') {
    return /*#__PURE__*/_react.default.createElement(InstallUpgradeFailedVersionStatus, {
      isUpgradeFailed: true,
      item: item,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 248,
        columnNumber: 12
      }
    });
  } else if (status === 'install_failed') {
    return /*#__PURE__*/_react.default.createElement(InstallUpgradeFailedVersionStatus, {
      isUpgradeFailed: false,
      item: item,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 250,
        columnNumber: 12
      }
    });
  } else return null;
});