"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BrowseIntegrationsPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _hooks = require("../../../../hooks");
var _no_epr_callout = require("../../components/no_epr_callout");
var _home = require("../home");
var _package_grid = require("./components/package_grid");
var _search_and_filters_bar = require("./components/search_and_filters_bar");
var _side_bar = require("./components/side_bar");
var _hooks2 = require("./hooks");
var _no_data_prompt = require("./components/no_data_prompt");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/screens/browse_integrations/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const BrowseIntegrationsPage = ({
  prereleaseIntegrationsEnabled
}) => {
  (0, _hooks.useBreadcrumbs)('integrations_all');
  const euiTheme = (0, _eui.useEuiTheme)();
  const {
    allCategories,
    initialSelectedCategory,
    selectedCategory,
    mainCategories,
    onlyAgentlessFilter,
    isLoading,
    isLoadingCategories,
    isLoadingAllPackages,
    isLoadingAppendCustomIntegrations,
    eprPackageLoadingError,
    eprCategoryLoadingError,
    searchTerm,
    setSearchTerm,
    setUrlandReplaceHistory,
    filteredCards,
    onCategoryChange
  } = (0, _hooks2.useBrowseIntegrationHook)({
    prereleaseIntegrationsEnabled
  });
  if (!isLoading && !(0, _home.categoryExists)(initialSelectedCategory, allCategories)) {
    setUrlandReplaceHistory({
      searchString: searchTerm,
      categoryId: '',
      subCategoryId: '',
      onlyAgentless: onlyAgentlessFilter
    });
    return null;
  }
  let noEprCallout;
  if (eprPackageLoadingError || eprCategoryLoadingError) {
    const error = eprPackageLoadingError || eprCategoryLoadingError;
    noEprCallout = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: 1,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_no_epr_callout.NoEprCallout, {
      statusCode: error === null || error === void 0 ? void 0 : error.statusCode,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "flexStart",
    gutterSize: "none",
    "data-test-subj": "epmList.integrationCards",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_side_bar.Sidebar, {
    isLoading: isLoading,
    categories: mainCategories,
    selectedCategory: selectedCategory,
    onCategoryChange: onCategoryChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 5,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_search_and_filters_bar.SearchAndFiltersBar, {
    searchTerm: searchTerm,
    setSearchTerm: setSearchTerm,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 11
    }
  }), noEprCallout ? noEprCallout : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    "data-test-subj": "epmList.mainColumn",
    style: {
      position: 'relative',
      backgroundColor: euiTheme.euiTheme.colors.backgroundBasePlain
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 11
    }
  }, filteredCards.length === 0 && !isLoading ? /*#__PURE__*/_react.default.createElement(_no_data_prompt.NoDataPrompt, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react.default.createElement(_package_grid.PackageGrid, {
    items: filteredCards,
    isLoading: isLoadingCategories || isLoadingAllPackages || isLoadingAppendCustomIntegrations,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 15
    }
  })))));
};
exports.BrowseIntegrationsPage = BrowseIntegrationsPage;