"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GridColumn = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactVirtualized = require("react-virtualized");
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _coreChromeLayoutConstants = require("@kbn/core-chrome-layout-constants");
var _package_card = require("../package_card");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/components/package_list_grid/grid.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const GridColumn = ({
  list,
  showMissingIntegrationMessage = false,
  showCardLabels = false,
  isLoading,
  scrollElementId,
  emptyStateStyles,
  columnCount = 3,
  gutterSize = 'm'
}) => {
  const windowScrollerRef = (0, _react.useRef)(null);
  const listRef = (0, _react.useRef)(null);
  const rowMeasurementCache = (0, _react.useRef)(new _reactVirtualized.CellMeasurerCache({
    fixedWidth: true,
    defaultHeight: 150
  }));

  // Reset the row measurement cache when the list changes
  (0, _react.useEffect)(() => {
    if (rowMeasurementCache.current) {
      rowMeasurementCache.current.clearAll();
    }
  }, [list]);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
      gutterSize: gutterSize,
      columns: columnCount,
      alignItems: "start",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 7
      }
    }, Array.from({
      length: 12
    }).map((_, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: index,
      grow: columnCount,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
      height: "160px",
      width: "100%",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 13
      }
    }))));
  }
  if (!list.length) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
      gutterSize: gutterSize,
      columns: columnCount,
      "data-test-subj": "emptyState",
      style: emptyStateStyles,
      alignItems: "start",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: columnCount,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 13
      }
    }, showMissingIntegrationMessage ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epmList.missingIntegrationPlaceholder",
      defaultMessage: "We didn't find any integrations matching your search term. Please try another keyword or browse using the categories on the left.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 17
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epmList.noPackagesFoundPlaceholder",
      defaultMessage: "No integrations found",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 17
      }
    })))));
  }
  const rowRenderer = ({
    index,
    key,
    parent,
    style
  }) => {
    const items = list.slice(index * columnCount, index * columnCount + columnCount);
    return /*#__PURE__*/_react.default.createElement(_reactVirtualized.CellMeasurer, {
      cache: rowMeasurementCache.current,
      key: key,
      columnIndex: 0,
      rowIndex: index,
      parent: parent,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 7
      }
    }, ({
      registerChild
    }) => /*#__PURE__*/_react.default.createElement("div", {
      ref: registerChild,
      style: style,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
      columns: columnCount,
      gutterSize: gutterSize,
      alignItems: "start",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 13
      }
    }, items.map(item => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: item.id
      // Ensure that cards wrapped in EuiTours/EuiPopovers correctly inherit the full grid row height
      ,
      css: (0, _react2.css)`
                    align-self: stretch;
                    min-width: 0;
                    & > .euiPopover,
                    & > .euiPopover > .euiCard {
                      height: 100%;
                    }
                  `,
      tabIndex: -1,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_package_card.PackageCard, (0, _extends2.default)({}, item, {
      showLabels: showCardLabels,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 19
      }
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: gutterSize,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 13
      }
    })));
  };
  return /*#__PURE__*/_react.default.createElement(_reactVirtualized.WindowScroller, {
    ref: windowScrollerRef,
    scrollElement: scrollElementId && document.getElementById(scrollElementId) || document.getElementById(_coreChromeLayoutConstants.APP_MAIN_SCROLL_CONTAINER_ID) || window,
    onResize: () => {
      if (rowMeasurementCache.current) {
        rowMeasurementCache.current.clearAll();
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 5
    }
  }, ({
    height,
    isScrolling,
    onChildScroll,
    scrollTop
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiAutoSizer, {
    disableHeight: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 9
    }
  }, ({
    width
  }) => /*#__PURE__*/_react.default.createElement(_reactVirtualized.List, {
    tabIndex: -1,
    ref: listRef,
    autoHeight: true,
    height: height,
    isScrolling: isScrolling,
    onScroll: onChildScroll,
    overscanRowCount: 2,
    rowCount: Math.ceil(list.length / columnCount),
    deferredMeasurementCache: rowMeasurementCache.current,
    rowHeight: rowMeasurementCache.current.rowHeight,
    rowRenderer: rowRenderer,
    scrollTop: scrollTop,
    width: width
    // Prevent clipping of card shadows on hover
    ,
    css: (0, _react2.css)`
                overflow: visible !important;
                .ReactVirtualized__Grid__innerScrollContainer {
                  overflow: visible !important;
                }
              `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 13
    }
  })));
};
exports.GridColumn = GridColumn;