"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoEprCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _hooks = require("../../../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/components/no_epr_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const NoEprCallout = ({
  statusCode
}) => {
  let titleMessage;
  let descriptionMessage;
  if (statusCode === 502) {
    titleMessage = _i18n.i18n.translate('xpack.fleet.epmList.eprUnavailableBadGatewayCalloutTitle', {
      defaultMessage: 'Kibana cannot reach the Elastic Package Registry, which provides Elastic Agent integrations'
    });
    descriptionMessage = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epmList.eprUnavailableCallouBdGatewaytTitleMessage",
      defaultMessage: "To view these integrations, configure a  {registryproxy} or host {onpremregistry}.",
      values: {
        registryproxy: /*#__PURE__*/_react.default.createElement(ProxyLink, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 34,
            columnNumber: 26
          }
        }),
        onpremregistry: /*#__PURE__*/_react.default.createElement(OnPremLink, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 35,
            columnNumber: 27
          }
        })
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 30,
        columnNumber: 7
      }
    });
  } else {
    titleMessage = _i18n.i18n.translate('xpack.fleet.epmList.eprUnavailable400500CalloutTitle', {
      defaultMessage: 'Kibana cannot connect to the Elastic Package Registry, which provides Elastic Agent integrations'
    });
    descriptionMessage = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epmList.eprUnavailableCallout400500TitleMessage",
      defaultMessage: "Ensure the {registryproxy} or {onpremregistry} is configured correctly, or try again later.",
      values: {
        registryproxy: /*#__PURE__*/_react.default.createElement(ProxyLink, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 49,
            columnNumber: 26
          }
        }),
        onpremregistry: /*#__PURE__*/_react.default.createElement(OnPremLink, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 50,
            columnNumber: 27
          }
        })
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: titleMessage,
    iconType: "info",
    color: 'warning',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }, descriptionMessage));
};
exports.NoEprCallout = NoEprCallout;
function ProxyLink() {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: docLinks.links.fleet.settingsFleetServerProxySettings,
    target: "_blank",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.fleet.epmList.proxyLinkSnippedText', {
    defaultMessage: 'proxy server'
  }));
}
function OnPremLink() {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: docLinks.links.fleet.onPremRegistry,
    target: "_blank",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.fleet.epmList.onPremLinkSnippetText', {
    defaultMessage: 'your own registry'
  }));
}