"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogstashInstructions = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../../hooks");
var _missing_privileges_tooltip = require("../../../../../../components/missing_privileges_tooltip");
var _helpers = require("./helpers");
var _hooks2 = require("./hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/settings/components/logstash_instructions/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LogstashInstructions = ({
  isSSLEnabled
}) => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  return /*#__PURE__*/_react.default.createElement(CollapsibleCallout, {
    iconType: "info",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.logstashInstructions.calloutTitle",
      defaultMessage: "Additional Logstash configuration required",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 9
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.logstashInstructions.description",
    defaultMessage: "Add an Elastic Agent pipeline configuration to Logstash to receive events from the Elastic Agent framework. {documentationLink}.",
    values: {
      documentationLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        external: true,
        target: "_blank",
        href: docLinks.links.logstash.inputElasticAgent,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 54,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.settings.logstashInstructions.documentationLink",
        defaultMessage: "Learn more",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 59,
          columnNumber: 17
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(LogstashInstructionSteps, {
    isSSLEnabled: isSSLEnabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 9
    }
  })));
};
exports.LogstashInstructions = LogstashInstructions;
const CollapsibleCallout = ({
  children,
  ...props
}) => {
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const authz = (0, _hooks.useAuthz)();
  const hasAllSettings = authz.fleet.allSettings;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, (0, _extends2.default)({}, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }), isOpen ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => setIsOpen(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.logstashInstructions.collapseInstructionsButtonLabel",
    defaultMessage: "Collapse steps",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 11
    }
  })) : /*#__PURE__*/_react.default.createElement(_missing_privileges_tooltip.MissingPrivilegesToolTip, {
    missingPrivilege: !hasAllSettings ? 'Settings All' : undefined,
    position: "left",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => setIsOpen(true),
    fill: true,
    disabled: !hasAllSettings,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.logstashInstructions.viewInstructionButtonLabel",
    defaultMessage: "View steps",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 13
    }
  }))), isOpen && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 11
    }
  }), children));
};
const LogstashInstructionSteps = ({
  isSSLEnabled
}) => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  const logstashApiKey = (0, _hooks2.useLogstashApiKey)();
  const authz = (0, _hooks.useAuthz)();
  const hasAllSettings = authz.fleet.allSettings;
  const steps = (0, _react.useMemo)(() => [{
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.logstashInstructions.apiKeyStepDescription",
      defaultMessage: "We recommend authorizing Logstash to output to Elasticsearch with minimal privileges for Elastic Agent.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 13
      }
    }), logstashApiKey.apiKey ? /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      paddingSize: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("h5", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 17
      }
    }, "API Key"), logstashApiKey.apiKey, /*#__PURE__*/_react.default.createElement("div", {
      className: "euiCodeBlock__controls",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "euiCodeBlock__copyButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
      textToCopy: logstashApiKey.apiKey,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 21
      }
    }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      onClick: copy,
      iconType: "copyClipboard",
      color: "text",
      disabled: !hasAllSettings,
      "aria-label": _i18n.i18n.translate('xpack.fleet.settings.logstashInstructions.copyApiKeyButtonLabel', {
        defaultMessage: 'Copy message'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 25
      }
    }))))) : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      isLoading: logstashApiKey.isLoading,
      onClick: logstashApiKey.generateApiKey,
      disabled: !hasAllSettings,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.logstashInstructions.generateApiKeyButtonLabel",
      defaultMessage: "Generate API key",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 13
      }
    }))
  }, {
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.logstashInstructions.editPipelineStepDescription",
      defaultMessage: "Next, open the {pipelineConfFile} file and insert the following content:",
      values: {
        pipelineConfFile: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 179,
            columnNumber: 35
          }
        }, "elastic-agent-pipeline.conf")
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 182,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      paddingSize: "m",
      language: "yaml",
      isCopyable: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 13
      }
    }, (0, _helpers.getLogstashPipeline)(isSSLEnabled, logstashApiKey.apiKey)))
  }, {
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.logstashInstructions.addPipelineStepDescription",
      defaultMessage: "In your Logstash configuration directory, open the {pipelineFile} file and add the following configuration. Replace the path to your file.",
      values: {
        pipelineFile: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 196,
            columnNumber: 31
          }
        }, "pipelines.yml")
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 192,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 199,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      paddingSize: "m",
      language: "yaml",
      isCopyable: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 200,
        columnNumber: 13
      }
    }, _helpers.LOGSTASH_CONFIG_PIPELINES))
  }, {
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.logstashInstructions.replaceStepDescription",
      defaultMessage: "Replace the parts between the brackets with your generated SSL certificate file paths. View {documentationLink} to generate the certificates.",
      values: {
        documentationLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          external: true,
          target: "_blank",
          href: docLinks.links.fleet.secureLogstash,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 214,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.settings.logstashInstructions.ourDocumentationLink",
          defaultMessage: "our documentation",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 219,
            columnNumber: 21
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 209,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 227,
        columnNumber: 13
      }
    }))
  }, {
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.logstashInstructions.saveAndRestartStepDescription",
      defaultMessage: "Save the pipeline and restart Logstash so the changes take effect.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 234,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 238,
        columnNumber: 13
      }
    }))
  }], [logstashApiKey, docLinks, hasAllSettings, isSSLEnabled]);
  return /*#__PURE__*/_react.default.createElement("ol", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 5
    }
  }, steps.map((step, idx) => /*#__PURE__*/_react.default.createElement("li", {
    key: idx,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 9
    }
  }, step.children)));
};