"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FleetIndexDebugger = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactQuery = require("@kbn/react-query");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("../../../../../../common");
var _hooks = require("../../../hooks");
var _services = require("../../../../../../common/services");
var _constants = require("../../../constants");
var _code_block = require("./code_block");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/debug/components/fleet_index_debugger.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const fetchIndex = async index => {
  if (!index) return null;
  const response = await (0, _hooks.sendRequest)({
    method: 'post',
    path: _services.debugRoutesService.getIndexPath(),
    body: {
      index
    },
    version: _common.API_VERSIONS.internal.v1
  });
  return response;
};
const FleetIndexDebugger = () => {
  var _error$reason, _indexResult$error, _indexResult$error$er, _indexResult$data;
  const indices = [{
    label: _common.AGENTS_INDEX,
    value: _common.AGENTS_INDEX
  }, {
    label: _common.AGENT_ACTIONS_INDEX,
    value: _common.AGENT_ACTIONS_INDEX
  }, {
    label: _constants.ENROLLMENT_API_KEYS_INDEX,
    value: _constants.ENROLLMENT_API_KEYS_INDEX
  }];
  const [index, setIndex] = (0, _react.useState)();
  const {
    data: indexResult,
    status
  } = (0, _reactQuery.useQuery)(['debug-indices', index], () => fetchIndex(index), {
    retry: false
  });
  const selectedOptions = index ? [indices.find(option => option.value === index)] : [];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.fleetIndexDebugger.description",
    defaultMessage: "Search for the contents of Fleet indices. Use the code block below to diagnose any potential issues. ",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    prepend: "Index",
    "aria-label": _i18n.i18n.translate('xpack.fleet.debug.fleetIndexDebugger.selectLabel', {
      defaultMessage: 'Select an index'
    }),
    placeholder: _i18n.i18n.translate('xpack.fleet.debug.fleetIndexDebugger.selectLabel', {
      defaultMessage: 'Select an index'
    }),
    fullWidth: true,
    options: indices,
    singleSelection: {
      asPlainText: true
    },
    selectedOptions: selectedOptions,
    isLoading: status === 'loading',
    onChange: newSelectedOptions => {
      if (!newSelectedOptions.length) {
        setIndex(undefined);
      } else {
        setIndex(newSelectedOptions[0].value);
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 13
    }
  })))), (indexResult === null || indexResult === void 0 ? void 0 : indexResult.error) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: "Error",
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 11
    }
  }, (_error$reason = indexResult === null || indexResult === void 0 ? void 0 : (_indexResult$error = indexResult.error) === null || _indexResult$error === void 0 ? void 0 : (_indexResult$error$er = _indexResult$error.error) === null || _indexResult$error$er === void 0 ? void 0 : _indexResult$error$er.reason) !== null && _error$reason !== void 0 ? _error$reason : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.fleetIndexDebugger.fetchError",
    defaultMessage: "Error fetching index data",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 15
    }
  }))), indexResult && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_code_block.CodeBlock, {
    value: JSON.stringify((_indexResult$data = indexResult.data) === null || _indexResult$data === void 0 ? void 0 : _indexResult$data.hits, null, 2),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 11
    }
  })));
};
exports.FleetIndexDebugger = FleetIndexDebugger;