"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableRowActions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _hooks = require("../../../../hooks");
var _components = require("../../components");
var _use_single_agent_menu_items = require("../../hooks/use_single_agent_menu_items");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/agent_list_page/components/table_row_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TableRowActions = ({
  agent,
  agentPolicy,
  onReassignClick,
  onUnenrollClick,
  onGetUninstallCommandClick,
  onUpgradeClick,
  onAddRemoveTagsClick,
  onRequestDiagnosticsClick,
  onMigrateAgentClick,
  onChangeAgentPrivilegeLevelClick,
  onViewAgentJsonClick,
  onRollbackClick
}) => {
  const {
    getHref
  } = (0, _hooks.useLink)();
  const [isMenuOpen, setIsMenuOpen] = (0, _react.useState)(false);

  // Build callbacks object for the hook
  const callbacks = (0, _react.useMemo)(() => ({
    onViewAgentClick: () => {
      window.location.href = getHref('agent_details', {
        agentId: agent.id
      });
    },
    onAddRemoveTagsClick,
    onReassignClick,
    onUpgradeClick,
    onViewAgentJsonClick,
    onMigrateAgentClick,
    onRequestDiagnosticsClick,
    onChangeAgentPrivilegeLevelClick,
    onUnenrollClick,
    onUninstallClick: onGetUninstallCommandClick,
    onRollbackClick
  }), [agent.id, getHref, onAddRemoveTagsClick, onReassignClick, onUpgradeClick, onViewAgentJsonClick, onMigrateAgentClick, onRequestDiagnosticsClick, onChangeAgentPrivilegeLevelClick, onUnenrollClick, onGetUninstallCommandClick, onRollbackClick]);
  const menuItems = (0, _use_single_agent_menu_items.useSingleAgentMenuItems)({
    agent,
    agentPolicy,
    callbacks
  });
  return /*#__PURE__*/_react.default.createElement(_components.HierarchicalActionsMenu, {
    items: menuItems,
    isOpen: isMenuOpen,
    onToggle: setIsMenuOpen,
    "data-test-subj": "agentActionsBtn",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 5
    }
  });
};
exports.TableRowActions = TableRowActions;