"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChangeAgentPrivilegeLevelFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../../../../../hooks");
var _action_secret_form_row = require("./action_secret_form_row");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/agent_list_page/components/change_agent_privilege_level_flyout/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ChangeAgentPrivilegeLevelFlyout = ({
  agents,
  agentCount,
  unsupportedAgents,
  onClose,
  onSave
}) => {
  var _useFleetStatus$isAct;
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const isActionSecretsStorageEnabled = (_useFleetStatus$isAct = (0, _hooks.useFleetStatus)().isActionSecretsStorageEnabled) !== null && _useFleetStatus$isAct !== void 0 ? _useFleetStatus$isAct : false;
  const changeAgentPrivilegeLevel = _hooks.sendChangeAgentPrivilegeLevel;
  const changeAgentsPrivilegeLevel = _hooks.sendBulkChangeAgentPrivilegeLevel;
  const [formContent, setFormContent] = (0, _react.useState)(null);
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)();
  const filteredAgents = (0, _react.useMemo)(() => Array.isArray(agents) ? agents.filter(agent => !unsupportedAgents.some(a => a.id === agent.id)) : agents, [agents, unsupportedAgents]);
  const filteredAgentCount = (0, _react.useMemo)(() => Array.isArray(filteredAgents) ? filteredAgents.length : agentCount, [agentCount, filteredAgents]);
  const handleFormChange = (key, value) => {
    if (formContent === null) {
      setFormContent({
        user_info: {
          [key]: value
        }
      });
    } else {
      setFormContent({
        user_info: {
          ...formContent.user_info,
          [key]: value
        }
      });
    }
  };
  const submitForm = async () => {
    try {
      if (Array.isArray(filteredAgents)) {
        if (filteredAgents.length === 1) {
          await changeAgentPrivilegeLevel({
            agentId: filteredAgents[0].id,
            body: formContent
          });
        } else {
          await changeAgentsPrivilegeLevel({
            body: {
              agents: filteredAgents.map(agent => agent.id),
              ...formContent
            }
          });
        }
      } else {
        await changeAgentsPrivilegeLevel({
          body: {
            agents: filteredAgents,
            ...formContent
          }
        });
      }
      notifications.toasts.addSuccess({
        title: _i18n.i18n.translate('xpack.fleet.agentList.changeAgentPrivilegeLevelFlyout.successNotificationTitle', {
          defaultMessage: 'Agent privilege level change initiated'
        }),
        text: _i18n.i18n.translate('xpack.fleet.agentList.changeAgentPrivilegeLevelFlyout.successNotificationDescription', {
          defaultMessage: 'The agent privilege level change process has been successfully initiated.'
        })
      });
      onSave();
    } catch (e) {
      notifications.toasts.addError(e, {
        title: _i18n.i18n.translate('xpack.fleet.agentList.changeAgentPrivilegeLevelFlyout.errorNotificationTitle', {
          defaultMessage: 'Failed to change privilege level for {agentCount, plural, one {agent} other {agents}}',
          values: {
            agentCount: filteredAgentCount
          }
        }),
        toastMessage: _i18n.i18n.translate('xpack.fleet.agentList.changeAgentPrivilegeLevelFlyout.errorNotificationDescription', {
          defaultMessage: 'The agent privilege level change process has failed.'
        })
      });
    }
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    "data-test-subj": "changeAgentPrivilegeLevelFlyout",
    onClose: onClose,
    "aria-labelledby": flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h1", {
    id: flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.changeAgentPrivilegeLevelFlyout.title",
    defaultMessage: "Remove {agentCount, plural, one {agent} other {agents}} root privilege",
    values: {
      agentCount: filteredAgentCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.changeAgentPrivilegeLevelFlyout.description",
    defaultMessage: "Change the privilege level of {agentCount, plural, one {this agent} other {these agents}} to unprivileged.",
    values: {
      agentCount: filteredAgentCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 13
    }
  })), Array.isArray(agents) && unsupportedAgents.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "warning",
    "data-test-subj": "changeAgentPrivilegeLevelFlyoutAlertPanel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "warning",
    className: "eui-alignMiddle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.changeAgentPrivilegeLevelFlyout.warning",
    defaultMessage: "{icon} Root privilege cannot be removed for {x} of {y} selected agents. These agents are either Fleet Server agents, already unprivileged agents, or agents on an unsupported version.",
    values: {
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "warning",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 184,
          columnNumber: 29
        }
      }),
      x: unsupportedAgents.length,
      y: agentCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "changeAgentPrivilegeLevelFlyoutWarningAccordion",
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: () => {},
      "aria-label": "View hosts",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 194,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.changeAgentPrivilegeLevelFlyout.warningAccordion",
      defaultMessage: "View hosts",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 195,
        columnNumber: 23
      }
    })),
    initialIsOpen: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("ul", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 21
    }
  }, unsupportedAgents.map(agent => {
    var _agent$local_metadata, _agent$local_metadata2;
    return /*#__PURE__*/_react.default.createElement("li", {
      key: agent.id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 207,
        columnNumber: 25
      }
    }, (_agent$local_metadata = agent.local_metadata) === null || _agent$local_metadata === void 0 ? void 0 : (_agent$local_metadata2 = _agent$local_metadata.host) === null || _agent$local_metadata2 === void 0 ? void 0 : _agent$local_metadata2.hostname);
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.changeAgentPrivilegeLevelFlyout.usernameLabel",
      defaultMessage: "Username (optional)",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 221,
        columnNumber: 17
      }
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.changeAgentPrivilegeLevelFlyout.usernameHelpText",
      defaultMessage: "The username of the user that runs the Elastic Agent",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 227,
        columnNumber: 17
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    placeholder: _i18n.i18n.translate('xpack.fleet.agentList.changeAgentPrivilegeLevelFlyout.usernamePlaceholder', {
      defaultMessage: 'Specify username'
    }),
    fullWidth: true,
    onChange: e => handleFormChange('username', e.target.value),
    "data-test-subj": "changeAgentPrivilegeLevelFlyout.usernameInput",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.changeAgentPrivilegeLevelFlyout.userGroupLabel",
      defaultMessage: "User group (optional)",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 248,
        columnNumber: 17
      }
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.changeAgentPrivilegeLevelFlyout.userGroupHelpText",
      defaultMessage: "The group of the user that runs the Elastic Agent",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 254,
        columnNumber: 17
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    placeholder: _i18n.i18n.translate('xpack.fleet.agentList.changeAgentPrivilegeLevelFlyout.userGroupPlaceholder', {
      defaultMessage: 'Specify user group'
    }),
    fullWidth: true,
    onChange: e => handleFormChange('groupname', e.target.value),
    "data-test-subj": "changeAgentPrivilegeLevelFlyout.userGroupInput",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_action_secret_form_row.SecretFormRow, {
    fullWidth: true,
    useSecretsStorage: isActionSecretsStorageEnabled,
    secretLabelTitle: _i18n.i18n.translate('xpack.fleet.agentList.changeAgentPrivilegeLevelFlyout.passwordLabel', {
      defaultMessage: 'User password (optional)'
    }),
    plainTextLabel: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.changeAgentPrivilegeLevelFlyout.passwordLabel",
      defaultMessage: "User password (optional)",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 282,
        columnNumber: 17
      }
    }),
    additionalHelpText: _i18n.i18n.translate('xpack.fleet.agentList.changeAgentPrivilegeLevelFlyout.userPasswordHelpText', {
      defaultMessage: 'The password of the user that runs the Elastic Agent'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldPassword, {
    fullWidth: true,
    type: "dual",
    "data-test-subj": "agentPrivilegeFlyout.passwordSecretInput",
    onChange: e => handleFormChange('password', e.target.value),
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.agentPrivilegeFlyout.passwordPlaceholder', {
      defaultMessage: 'Specify user password'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 309,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 310,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": "Cancel",
    onClick: onClose,
    "data-test-subj": "changeAgentPrivilegeLevelFlyoutCancelButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 311,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.changeAgentPrivilegeLevelFlyout.cancelButtonLabel",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 316,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: submitForm,
    fill: true,
    disabled: filteredAgentCount === 0,
    "data-test-subj": "changeAgentPrivilegeLevelFlyoutSubmitButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 321,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.changeAgentPrivilegeLevelFlyout.submitButtonLabel",
    defaultMessage: "Remove privilege for {agentCount, plural, one {# agent} other {# agents}}",
    values: {
      agentCount: filteredAgentCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 327,
      columnNumber: 15
    }
  }))))));
};
exports.ChangeAgentPrivilegeLevelFlyout = ChangeAgentPrivilegeLevelFlyout;