"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentBulkActions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _services = require("../../../../services");
var _components = require("../../components");
var _hooks = require("../../../../hooks");
var _constants = require("../../../../../../../common/constants");
var _utils = require("../utils");
var _agent_request_diagnostics_modal = require("../../components/agent_request_diagnostics_modal");
var _export_csv = require("../hooks/export_csv");
var _agent_export_csv_modal = require("../../components/agent_export_csv_modal");
var _agent_rollback_modal = require("../../components/agent_rollback_modal");
var _tags_add_remove = require("./tags_add_remove");
var _migrate_agent_flyout = require("./migrate_agent_flyout");
var _change_agent_privilege_level_flyout = require("./change_agent_privilege_level_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/agent_list_page/components/bulk_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AgentBulkActions = ({
  nAgentsInTable,
  totalManagedAgentIds,
  selectionMode,
  currentQuery,
  selectedAgents,
  agentsOnCurrentPage,
  refreshAgents,
  allTags,
  agentPolicies,
  sortField,
  sortOrder,
  unsupportedMigrateAgents,
  unsupportedPrivilegeLevelChangeAgents
}) => {
  const licenseService = (0, _hooks.useLicense)();
  const authz = (0, _hooks.useAuthz)();
  const {
    cloud
  } = (0, _hooks.useStartServices)();
  const isLicenceAllowingScheduleUpgrade = licenseService.hasAtLeast(_constants.LICENSE_FOR_SCHEDULE_UPGRADE);
  const doesLicenseAllowMigration = licenseService.hasAtLeast(_constants.LICENSE_FOR_AGENT_MIGRATION);
  const doesLicenseAllowRollback = licenseService.hasAtLeast(_constants.LICENSE_FOR_AGENT_ROLLBACK);
  const agentPrivilegeLevelChangeEnabled = _services.ExperimentalFeaturesService.get().enableAgentPrivilegeLevelChange;
  const agentRollbackEnabled = _services.ExperimentalFeaturesService.get().enableAgentRollback;

  // Bulk actions menu states
  const [isMenuOpen, setIsMenuOpen] = (0, _react.useState)(false);

  // Actions states
  const [isReassignFlyoutOpen, setIsReassignFlyoutOpen] = (0, _react.useState)(false);
  const [isUnenrollModalOpen, setIsUnenrollModalOpen] = (0, _react.useState)(false);
  const [upgradeModalState, setUpgradeModalState] = (0, _react.useState)({
    isOpen: false,
    isScheduled: false,
    isUpdating: false
  });
  const [isTagAddVisible, setIsTagAddVisible] = (0, _react.useState)(false);
  const [isRequestDiagnosticsModalOpen, setIsRequestDiagnosticsModalOpen] = (0, _react.useState)(false);
  const [isExportCSVModalOpen, setIsExportCSVModalOpen] = (0, _react.useState)(false);
  const [isMigrateModalOpen, setIsMigrateModalOpen] = (0, _react.useState)(false);
  const [isAgentPrivilegeChangeModalOpen, setIsAgentPrivilegeChangeModalOpen] = (0, _react.useState)(false);
  const [isRollbackModalOpen, setIsRollbackModalOpen] = (0, _react.useState)(false);

  // update the query removing the "managed" agents in any state (unenrolled, offline, etc)
  const selectionQuery = (0, _react.useMemo)(() => {
    if (totalManagedAgentIds.length) {
      const excludedKuery = `${_constants.AGENTS_PREFIX}.agent.id : (${totalManagedAgentIds.map(id => `"${id}"`).join(' or ')})`;
      return `(${currentQuery}) AND NOT (${excludedKuery})`;
    } else {
      return currentQuery;
    }
  }, [currentQuery, totalManagedAgentIds]);
  const agents = selectionMode === 'manual' ? selectedAgents : selectionQuery;
  const agentCount = selectionMode === 'manual' ? selectedAgents.length : nAgentsInTable - (totalManagedAgentIds === null || totalManagedAgentIds === void 0 ? void 0 : totalManagedAgentIds.length);
  const [tagsPopoverButton, setTagsPopoverButton] = (0, _react.useState)();
  const {
    generateReportingJobCSV
  } = (0, _export_csv.useExportCSV)();
  const maintainanceItems = (0, _react.useMemo)(() => {
    return [{
      id: 'migrate',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentBulkActions.bulkMigrateAgents",
        defaultMessage: "Migrate {agentCount, plural, one {# agent} other {# agents}}",
        values: {
          agentCount
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 128,
          columnNumber: 11
        }
      }),
      icon: 'cluster',
      disabled: !authz.fleet.allAgents || !doesLicenseAllowMigration,
      onClick: () => {
        setIsMigrateModalOpen(true);
      },
      'data-test-subj': 'agentBulkActionsBulkMigrate'
    }, {
      id: 'diagnostics',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentBulkActions.requestDiagnostics",
        defaultMessage: "Request diagnostics for {agentCount, plural, one {# agent} other {# agents}}",
        values: {
          agentCount
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 144,
          columnNumber: 11
        }
      }),
      icon: 'download',
      disabled: !authz.fleet.readAgents,
      onClick: () => {
        setIsRequestDiagnosticsModalOpen(true);
      },
      'data-test-subj': 'agentBulkActionsRequestDiagnostics'
    }];
  }, [agentCount, authz.fleet.allAgents, authz.fleet.readAgents, doesLicenseAllowMigration]);

  // remove serverless check when https://github.com/elastic/kibana/issues/232193 is resolved
  if (!(cloud !== null && cloud !== void 0 && cloud.isServerlessEnabled)) {
    maintainanceItems.push({
      id: 'export',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentBulkActions.exportAgents",
        defaultMessage: "Export {agentCount, plural, one {# agent} other {# agents}} as CSV",
        values: {
          agentCount
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 165,
          columnNumber: 9
        }
      }),
      icon: 'exportAction',
      disabled: !authz.fleet.readAgents,
      onClick: () => {
        setIsExportCSVModalOpen(true);
      },
      'data-test-subj': 'bulkAgentExportBtn'
    });
  }

  // Build hierarchical menu items
  const menuItems = (0, _react.useMemo)(() => {
    const items = [
    // Top-level items
    {
      id: 'tags',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentBulkActions.addRemoveTags",
        defaultMessage: "Add / remove tags",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 187,
          columnNumber: 11
        }
      }),
      icon: 'tag',
      disabled: !authz.fleet.allAgents,
      keepMenuOpen: true,
      onClick: event => {
        setTagsPopoverButton(event.target.closest('button'));
        setIsTagAddVisible(!isTagAddVisible);
      },
      'data-test-subj': 'agentBulkActionsAddRemoveTags'
    }, {
      id: 'reassign',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentBulkActions.reassignPolicy",
        defaultMessage: "Assign to new policy",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 204,
          columnNumber: 11
        }
      }),
      icon: 'pencil',
      disabled: !authz.fleet.allAgents,
      onClick: () => {
        setIsReassignFlyoutOpen(true);
      },
      'data-test-subj': 'agentBulkActionsReassign'
    }, {
      id: 'upgrade',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentBulkActions.upgradeAgents",
        defaultMessage: "Upgrade {agentCount, plural, one {# agent} other {# agents}}",
        values: {
          agentCount
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 219,
          columnNumber: 11
        }
      }),
      icon: 'refresh',
      disabled: !authz.fleet.allAgents,
      onClick: () => {
        setUpgradeModalState({
          isOpen: true,
          isScheduled: false,
          isUpdating: false
        });
      },
      'data-test-subj': 'agentBulkActionsUpgrade'
    },
    // Upgrade management submenu
    {
      id: 'upgrade-management',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentBulkActions.upgradeManagement",
        defaultMessage: "Upgrade management",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 236,
          columnNumber: 11
        }
      }),
      panelTitle: 'Upgrade management',
      children: [{
        id: 'schedule-upgrade',
        name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.agentBulkActions.scheduleUpgradeAgents",
          defaultMessage: "Schedule upgrade for {agentCount, plural, one {# agent} other {# agents}}",
          values: {
            agentCount
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 246,
            columnNumber: 15
          }
        }),
        icon: 'timeRefresh',
        disabled: !authz.fleet.allAgents || !isLicenceAllowingScheduleUpgrade,
        onClick: () => {
          setUpgradeModalState({
            isOpen: true,
            isScheduled: true,
            isUpdating: false
          });
        },
        'data-test-subj': 'agentBulkActionsScheduleUpgrade'
      }, {
        id: 'restart-upgrade',
        name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.agentBulkActions.restartUpgradeAgents",
          defaultMessage: "Restart upgrade for {agentCount, plural, one {# agent} other {# agents}}",
          values: {
            agentCount
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 262,
            columnNumber: 15
          }
        }),
        icon: 'refresh',
        disabled: !authz.fleet.allAgents,
        onClick: () => {
          setUpgradeModalState({
            isOpen: true,
            isScheduled: false,
            isUpdating: true
          });
        },
        'data-test-subj': 'agentBulkActionsRestartUpgrade'
      }, ...(agentRollbackEnabled ? [{
        id: 'rollback-upgrade',
        name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.agentBulkActions.rollbackUpgradeAgents",
          defaultMessage: "Roll back upgrade for {agentCount, plural, one {# agent} other {# agents}}",
          values: {
            agentCount
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 280,
            columnNumber: 21
          }
        }),
        icon: 'clockCounter',
        disabled: !authz.fleet.allAgents || !doesLicenseAllowRollback,
        onClick: () => {
          setIsRollbackModalOpen(true);
        },
        'data-test-subj': 'agentBulkActionsRollbackUpgrade'
      }] : [])]
    },
    // Maintenance and diagnostics submenu
    {
      id: 'maintenance',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentBulkActions.maintenanceAndDiagnostics",
        defaultMessage: "Maintenance and diagnostics",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 301,
          columnNumber: 11
        }
      }),
      panelTitle: 'Maintenance and diagnostics',
      children: maintainanceItems
    },
    // Security and removal submenu
    {
      id: 'security',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentBulkActions.securityAndRemoval",
        defaultMessage: "Security and removal",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 313,
          columnNumber: 11
        }
      }),
      panelTitle: 'Security and removal',
      children: [...(agentPrivilegeLevelChangeEnabled ? [{
        id: 'remove-root',
        name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.agentBulkActions.bulkChangeAgentsPrivilegeLevel",
          defaultMessage: "Remove root access for {agentCount, plural, one {# agent} other {# agents}}",
          values: {
            agentCount
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 325,
            columnNumber: 21
          }
        }),
        icon: 'lock',
        disabled: !authz.fleet.allAgents,
        onClick: () => {
          setIsAgentPrivilegeChangeModalOpen(true);
        },
        'data-test-subj': 'agentBulkActionsBulkChangeAgentsPrivilegeLevel'
      }] : []), {
        id: 'unenroll',
        name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.agentBulkActions.unenrollAgents",
          defaultMessage: "Unenroll {agentCount, plural, one {# agent} other {# agents}}",
          values: {
            agentCount
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 343,
            columnNumber: 15
          }
        }),
        icon: 'trash',
        iconColor: 'danger',
        disabled: !authz.fleet.allAgents,
        onClick: () => {
          setIsUnenrollModalOpen(true);
        },
        'data-test-subj': 'agentBulkActionsUnenroll'
      }]
    }];
    return items;
  }, [authz.fleet.allAgents, agentCount, isLicenceAllowingScheduleUpgrade, agentRollbackEnabled, doesLicenseAllowRollback, maintainanceItems, agentPrivilegeLevelChangeEnabled, isTagAddVisible]);
  const getSelectedTagsFromAgents = (0, _react.useMemo)(() => (0, _utils.getCommonTags)(agents, agentsOnCurrentPage !== null && agentsOnCurrentPage !== void 0 ? agentsOnCurrentPage : [], agentPolicies), [agents, agentsOnCurrentPage, agentPolicies]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isReassignFlyoutOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 381,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_components.AgentReassignAgentPolicyModal, {
    agents: agents,
    onClose: () => {
      setIsReassignFlyoutOpen(false);
      refreshAgents();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 382,
      columnNumber: 11
    }
  })), isUnenrollModalOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 392,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_components.AgentUnenrollAgentModal, {
    agents: agents,
    agentCount: agentCount,
    onClose: () => {
      setIsUnenrollModalOpen(false);
      refreshAgents({
        refreshTags: true
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 393,
      columnNumber: 11
    }
  })), isExportCSVModalOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 404,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_agent_export_csv_modal.AgentExportCSVModal, {
    onSubmit: columns => {
      generateReportingJobCSV(agents, columns, {
        field: sortField,
        direction: sortOrder
      });
      setIsExportCSVModalOpen(false);
    },
    onClose: () => {
      setIsExportCSVModalOpen(false);
    },
    agentCount: agentCount,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 405,
      columnNumber: 11
    }
  })), upgradeModalState.isOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 421,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_components.AgentUpgradeAgentModal, {
    agents: agents,
    agentCount: agentCount,
    isScheduled: upgradeModalState.isScheduled,
    isUpdating: upgradeModalState.isUpdating,
    onClose: () => {
      setUpgradeModalState({
        isOpen: false,
        isScheduled: false,
        isUpdating: false
      });
      refreshAgents();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 422,
      columnNumber: 11
    }
  })), isTagAddVisible && /*#__PURE__*/_react.default.createElement(_tags_add_remove.TagsAddRemove, {
    agents: Array.isArray(agents) ? agents.map(agent => agent.id) : agents,
    allTags: allTags !== null && allTags !== void 0 ? allTags : [],
    selectedTags: getSelectedTagsFromAgents,
    button: tagsPopoverButton,
    onTagsUpdated: () => {
      refreshAgents({
        refreshTags: true
      });
    },
    onClosePopover: () => {
      setIsTagAddVisible(false);
      setIsMenuOpen(false);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 435,
      columnNumber: 9
    }
  }), isRequestDiagnosticsModalOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 450,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_agent_request_diagnostics_modal.AgentRequestDiagnosticsModal, {
    agents: agents,
    agentCount: agentCount,
    onClose: () => {
      setIsRequestDiagnosticsModalOpen(false);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 451,
      columnNumber: 11
    }
  })), isMigrateModalOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 461,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_migrate_agent_flyout.AgentMigrateFlyout, {
    agents: agents,
    agentCount: agentCount,
    unsupportedMigrateAgents: unsupportedMigrateAgents,
    onClose: () => {
      setIsMigrateModalOpen(false);
    },
    onSave: () => {
      setIsMigrateModalOpen(false);
      refreshAgents();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 462,
      columnNumber: 11
    }
  })), isAgentPrivilegeChangeModalOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 477,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_change_agent_privilege_level_flyout.ChangeAgentPrivilegeLevelFlyout, {
    agents: agents,
    agentCount: agentCount,
    unsupportedAgents: unsupportedPrivilegeLevelChangeAgents,
    onClose: () => {
      setIsAgentPrivilegeChangeModalOpen(false);
    },
    onSave: () => {
      setIsAgentPrivilegeChangeModalOpen(false);
      refreshAgents();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 478,
      columnNumber: 11
    }
  })), isRollbackModalOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 493,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_agent_rollback_modal.AgentRollbackModal, {
    agents: agents,
    agentCount: agentCount,
    onClose: () => {
      setIsRollbackModalOpen(false);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 494,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 503,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 504,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_components.HierarchicalActionsMenu, {
    items: menuItems,
    isOpen: isMenuOpen,
    anchorPosition: "downLeft",
    onToggle: setIsMenuOpen,
    button: {
      props: {
        iconType: 'arrowDown',
        iconSide: 'right',
        fill: true
      },
      children: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentBulkActions.actions",
        defaultMessage: "Actions",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 517,
          columnNumber: 17
        }
      })
    },
    "data-test-subj": "agentBulkActionsButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 505,
      columnNumber: 11
    }
  }))));
};
exports.AgentBulkActions = AgentBulkActions;