"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentSoftLimitCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/agent_list_page/components/agent_soft_limit_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AgentSoftLimitCallout = () => {
  var _config$internal$acti, _config$internal;
  const config = (0, _hooks.useConfig)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "warning",
    color: "warning",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentSoftLimitCallout.calloutTitle",
      defaultMessage: "Max number of online agents reached",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 22,
        columnNumber: 9
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 18,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentSoftLimitCallout.calloutDescription",
    defaultMessage: "Fleet supports a maximum of {nbAgents} active agents. You need to unenroll some agents to ensure that all active agents are able to connect and new agents can be enrolled.",
    values: {
      nbAgents: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedNumber, {
        value: (_config$internal$acti = (_config$internal = config.internal) === null || _config$internal === void 0 ? void 0 : _config$internal.activeAgentsSoftLimit) !== null && _config$internal$acti !== void 0 ? _config$internal$acti : 25000,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 32,
          columnNumber: 21
        }
      })
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 7
    }
  }));
};
exports.AgentSoftLimitCallout = AgentSoftLimitCallout;