"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentDetailsActionMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _components = require("../../components");
var _use_single_agent_menu_items = require("../../hooks/use_single_agent_menu_items");
var _hooks = require("../hooks");
var _services = require("../../../../services");
var _agent_request_diagnostics_modal = require("../../components/agent_request_diagnostics_modal");
var _components2 = require("../../agent_list_page/components");
var _components3 = require("../../../../components");
var _agent_rollback_modal = require("../../components/agent_rollback_modal");
var _agent_details_json_flyout = require("./agent_details_json_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/agent_details_page/components/actions_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AgentDetailsActionMenu = exports.AgentDetailsActionMenu = /*#__PURE__*/(0, _react.memo)(({
  agent,
  assignFlyoutOpenByDefault = false,
  onCancelReassign,
  agentPolicy,
  onAddRemoveTagsClick
}) => {
  const refreshAgent = (0, _hooks.useAgentRefresh)();

  // Modal/flyout state
  const [isReassignFlyoutOpen, setIsReassignFlyoutOpen] = (0, _react.useState)(assignFlyoutOpenByDefault);
  const [isUnenrollModalOpen, setIsUnenrollModalOpen] = (0, _react.useState)(false);
  const [isUpgradeModalOpen, setIsUpgradeModalOpen] = (0, _react.useState)(false);
  const [isRequestDiagnosticsModalOpen, setIsRequestDiagnosticsModalOpen] = (0, _react.useState)(false);
  const [isAgentDetailsJsonFlyoutOpen, setIsAgentDetailsJsonFlyoutOpen] = (0, _react.useState)(false);
  const [isAgentMigrateFlyoutOpen, setIsAgentMigrateFlyoutOpen] = (0, _react.useState)(false);
  const [isChangePrivilegeLevelFlyoutOpen, setIsChangePrivilegeLevelFlyoutOpen] = (0, _react.useState)(false);
  const [isUninstallCommandFlyoutOpen, setIsUninstallCommandFlyoutOpen] = (0, _react.useState)(false);
  const [isRollbackModalOpen, setIsRollbackModalOpen] = (0, _react.useState)(false);
  const [isMenuOpen, setIsMenuOpen] = (0, _react.useState)(false);
  const onMenuToggle = (0, _react.useCallback)(open => {
    setIsMenuOpen(open);
  }, []);
  const hasFleetServer = agentPolicy && (0, _services.policyHasFleetServer)(agentPolicy);
  const isUnenrolling = agent.status === 'unenrolling';
  const onClose = (0, _react.useMemo)(() => {
    if (onCancelReassign) {
      return onCancelReassign;
    } else {
      return () => setIsReassignFlyoutOpen(false);
    }
  }, [onCancelReassign, setIsReassignFlyoutOpen]);

  // Build callbacks for the shared hook
  const callbacks = (0, _react.useMemo)(() => ({
    // No onViewAgentClick - we're already on agent details page
    onAddRemoveTagsClick,
    onReassignClick: () => setIsReassignFlyoutOpen(true),
    onUpgradeClick: () => setIsUpgradeModalOpen(true),
    onViewAgentJsonClick: () => setIsAgentDetailsJsonFlyoutOpen(true),
    onMigrateAgentClick: () => setIsAgentMigrateFlyoutOpen(true),
    onRequestDiagnosticsClick: () => setIsRequestDiagnosticsModalOpen(true),
    onChangeAgentPrivilegeLevelClick: () => setIsChangePrivilegeLevelFlyoutOpen(true),
    onUnenrollClick: () => setIsUnenrollModalOpen(true),
    onUninstallClick: () => setIsUninstallCommandFlyoutOpen(true),
    onRollbackClick: () => setIsRollbackModalOpen(true)
  }), [onAddRemoveTagsClick]);

  // Use the shared hook for menu items
  const menuItems = (0, _use_single_agent_menu_items.useSingleAgentMenuItems)({
    agent,
    agentPolicy,
    callbacks
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isReassignFlyoutOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_components.AgentReassignAgentPolicyModal, {
    agents: [agent],
    onClose: onClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 13
    }
  })), isUnenrollModalOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_components.AgentUnenrollAgentModal, {
    agents: [agent],
    agentCount: 1,
    onClose: () => {
      setIsUnenrollModalOpen(false);
      refreshAgent();
    },
    useForceUnenroll: isUnenrolling,
    hasFleetServer: hasFleetServer,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 13
    }
  })), isUpgradeModalOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_components.AgentUpgradeAgentModal, {
    agents: [agent],
    agentCount: 1,
    onClose: () => {
      setIsUpgradeModalOpen(false);
      refreshAgent();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 13
    }
  })), isRequestDiagnosticsModalOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_agent_request_diagnostics_modal.AgentRequestDiagnosticsModal, {
    agents: [agent],
    agentCount: 1,
    onClose: () => {
      setIsRequestDiagnosticsModalOpen(false);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 13
    }
  })), isAgentDetailsJsonFlyoutOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_agent_details_json_flyout.AgentDetailsJsonFlyout, {
    agent: agent,
    onClose: () => setIsAgentDetailsJsonFlyoutOpen(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 13
    }
  })), isAgentMigrateFlyoutOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_components2.AgentMigrateFlyout, {
    agents: [agent],
    agentCount: 1,
    unsupportedMigrateAgents: [],
    onClose: () => {
      setIsAgentMigrateFlyoutOpen(false);
    },
    onSave: () => {
      setIsAgentMigrateFlyoutOpen(false);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 13
    }
  })), isChangePrivilegeLevelFlyoutOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_components2.ChangeAgentPrivilegeLevelFlyout, {
    agents: [agent],
    agentCount: 1,
    unsupportedAgents: [],
    onClose: () => {
      setIsChangePrivilegeLevelFlyoutOpen(false);
    },
    onSave: () => {
      setIsChangePrivilegeLevelFlyoutOpen(false);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 13
    }
  })), isUninstallCommandFlyoutOpen && agent.policy_id && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_components3.UninstallCommandFlyout, {
    target: "agent",
    policyId: agent.policy_id,
    onClose: () => {
      setIsUninstallCommandFlyoutOpen(false);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 13
    }
  })), isRollbackModalOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_agent_rollback_modal.AgentRollbackModal, {
    agents: [agent],
    agentCount: 1,
    onClose: () => setIsRollbackModalOpen(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_components.HierarchicalActionsMenu, {
    items: menuItems,
    isOpen: isMenuOpen,
    onToggle: onMenuToggle,
    anchorPosition: "downLeft",
    button: {
      props: {
        iconType: 'arrowDown',
        iconSide: 'right',
        color: 'primary'
      },
      children: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentDetails.actionsButton",
        defaultMessage: "Actions",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 215,
          columnNumber: 15
        }
      })
    },
    "data-test-subj": "agentActionsBtn",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 9
    }
  }));
});