"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.outputType = exports.kafkaVerificationModes = exports.kafkaTopicsType = exports.kafkaTopicsOptions = exports.kafkaTopicWhenType = exports.kafkaSupportedVersions = exports.kafkaSaslMechanism = exports.kafkaPartitionType = exports.kafkaConnectionType = exports.kafkaCompressionType = exports.kafkaAuthType = exports.kafkaAcknowledgeReliabilityLevel = exports.SERVERLESS_DEFAULT_OUTPUT_ID = exports.SERVERLESS_AGENTLESS_OUTPUT_ID = exports.RESERVED_CONFIG_YML_KEYS = exports.OUTPUT_TYPES_WITH_PRESET_SUPPORT = exports.OUTPUT_SAVED_OBJECT_TYPE = exports.OUTPUT_HEALTH_DATA_STREAM = exports.LOGSTASH_API_KEY_INDICES_PRIVILEGES = exports.LOGSTASH_API_KEY_INDICES = exports.LOGSTASH_API_KEY_CLUSTER_PERMISSIONS = exports.LICENCE_FOR_PER_POLICY_OUTPUT = exports.LICENCE_FOR_OUTPUT_PER_INTEGRATION = exports.KAFKA_DYNAMIC_FIELDS = exports.ECH_AGENTLESS_OUTPUT_ID = exports.DEFAULT_OUTPUT_ID = exports.DEFAULT_OUTPUT = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OUTPUT_SAVED_OBJECT_TYPE = exports.OUTPUT_SAVED_OBJECT_TYPE = 'ingest-outputs';
const outputType = exports.outputType = {
  Elasticsearch: 'elasticsearch',
  Logstash: 'logstash',
  Kafka: 'kafka',
  RemoteElasticsearch: 'remote_elasticsearch'
};
const DEFAULT_OUTPUT_ID = exports.DEFAULT_OUTPUT_ID = 'fleet-default-output';
const DEFAULT_OUTPUT = exports.DEFAULT_OUTPUT = {
  name: 'default',
  is_default: true,
  is_default_monitoring: true,
  type: outputType.Elasticsearch,
  hosts: ['']
};
const SERVERLESS_DEFAULT_OUTPUT_ID = exports.SERVERLESS_DEFAULT_OUTPUT_ID = 'es-default-output';

// Output IDs used for agentless policies:
//  - For ECH, this is an output created by Fleet, see `ensureDefaultOutputs()` in
//    `x-pack/plugins/fleet/server/services/output.ts`
//  - For Serverless, this is the `es-default-output` output that is created from
//    preconfiguration via project controller
//  - Both are uneditable by users due to having `is_preconfigured: true` set
const ECH_AGENTLESS_OUTPUT_ID = exports.ECH_AGENTLESS_OUTPUT_ID = 'es-agentless-output';
const SERVERLESS_AGENTLESS_OUTPUT_ID = exports.SERVERLESS_AGENTLESS_OUTPUT_ID = SERVERLESS_DEFAULT_OUTPUT_ID;
const LICENCE_FOR_PER_POLICY_OUTPUT = exports.LICENCE_FOR_PER_POLICY_OUTPUT = 'platinum';
const LICENCE_FOR_OUTPUT_PER_INTEGRATION = exports.LICENCE_FOR_OUTPUT_PER_INTEGRATION = 'enterprise';

/**
 * Kafka constants
 */

const kafkaCompressionType = exports.kafkaCompressionType = {
  None: 'none',
  Snappy: 'snappy',
  Lz4: 'lz4',
  Gzip: 'gzip'
};
const kafkaAuthType = exports.kafkaAuthType = {
  Userpass: 'user_pass',
  Ssl: 'ssl',
  Kerberos: 'kerberos',
  None: 'none'
};
const kafkaConnectionType = exports.kafkaConnectionType = {
  Plaintext: 'plaintext',
  Encryption: 'encryption'
};
const kafkaSaslMechanism = exports.kafkaSaslMechanism = {
  Plain: 'PLAIN',
  ScramSha256: 'SCRAM-SHA-256',
  ScramSha512: 'SCRAM-SHA-512'
};
const kafkaPartitionType = exports.kafkaPartitionType = {
  Random: 'random',
  RoundRobin: 'round_robin',
  Hash: 'hash'
};
const kafkaTopicsType = exports.kafkaTopicsType = {
  Static: 'static',
  Dynamic: 'dynamic'
};
const kafkaTopicWhenType = exports.kafkaTopicWhenType = {
  Equals: 'equals',
  Contains: 'contains',
  Regexp: 'regexp'
};
const kafkaAcknowledgeReliabilityLevel = exports.kafkaAcknowledgeReliabilityLevel = {
  Commit: 1,
  Replica: -1,
  DoNotWait: 0
};
const kafkaVerificationModes = exports.kafkaVerificationModes = {
  Full: 'full',
  None: 'none',
  Strict: 'strict',
  Certificate: 'certificate'
};
const kafkaSupportedVersions = exports.kafkaSupportedVersions = ['0.8.2.0', '0.8.2.1', '0.8.2.2', '0.9.0.0', '0.9.0.1', '0.10.0.0', '0.10.0.1', '0.10.1.0', '0.10.1.1', '0.10.2.0', '0.10.2.1', '0.10.2.2', '0.11.0.0', '0.11.0.1', '0.11.0.2', '0.11.0.3', '1.0.0', '1.0.1', '1.0.2', '1.1.0', '1.1.1', '2.0.0', '2.0.1', '2.1.0', '2.1.1', '2.2.0', '2.2.1', '2.2.2', '2.3.0', '2.3.1', '2.4.0', '2.4.1', '2.5.0', '2.5.1', '2.6.0'];
const RESERVED_CONFIG_YML_KEYS = exports.RESERVED_CONFIG_YML_KEYS = ['bulk_max_size', 'compression_level', 'connection_idle_timeout', 'queue.mem.events', 'queue.mem.flush.min_events', 'queue.mem.flush.timeout', 'worker'];
const kafkaTopicsOptions = exports.kafkaTopicsOptions = [{
  id: kafkaTopicsType.Static,
  label: 'Static Topic',
  'data-test-subj': 'kafkaTopicStaticRadioButton'
}, {
  id: kafkaTopicsType.Dynamic,
  label: 'Dynamic Topic',
  'data-test-subj': 'kafkaTopicDynamicRadioButton'
}];
const KAFKA_DYNAMIC_FIELDS = exports.KAFKA_DYNAMIC_FIELDS = ['data_stream.type', 'data_stream.dataset', 'data_stream.namespace', '@timestamp', 'event.dataset'];
const OUTPUT_TYPES_WITH_PRESET_SUPPORT = exports.OUTPUT_TYPES_WITH_PRESET_SUPPORT = [outputType.Elasticsearch, outputType.RemoteElasticsearch];
const OUTPUT_HEALTH_DATA_STREAM = exports.OUTPUT_HEALTH_DATA_STREAM = 'logs-fleet_server.output_health-default';
const LOGSTASH_API_KEY_CLUSTER_PERMISSIONS = exports.LOGSTASH_API_KEY_CLUSTER_PERMISSIONS = ['monitor', 'manage_own_api_key'];
const LOGSTASH_API_KEY_INDICES_PRIVILEGES = exports.LOGSTASH_API_KEY_INDICES_PRIVILEGES = ['auto_configure', 'create_doc'];
const LOGSTASH_API_KEY_INDICES = exports.LOGSTASH_API_KEY_INDICES = ['logs-*-*', 'metrics-*-*', 'traces-*-*', 'synthetics-*-*', '.logs-endpoint.diagnostic.collection-*', '.logs-endpoint.action.responses-*', 'profiling-*', '.profiling-*'];