"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FileUploadTelemetryService = void 0;
var _register_telemetry = require("./register_telemetry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class FileUploadTelemetryService {
  constructor(analytics, location) {
    this.analytics = analytics;
    this.location = location;
  }
  reportEvent(eventType, eventData) {
    try {
      this.analytics.reportEvent(eventType, eventData);
    } catch (error) {
      // eslint-disable-next-line no-console
      console.log('Failed to report telemetry event', error);
    }
  }
  trackAnalyzeFile(fileUploadEvent) {
    this.reportEvent(_register_telemetry.FILE_UPLOAD_EVENT.FILE_ANALYSIS, {
      ...fileUploadEvent,
      location: this.location
    });
  }
  trackUploadFile(fileUploadEvent) {
    this.reportEvent(_register_telemetry.FILE_UPLOAD_EVENT.FILE_UPLOAD, {
      ...fileUploadEvent,
      location: this.location
    });
  }
  trackUploadSession(uploadSessionEvent) {
    this.reportEvent(_register_telemetry.FILE_UPLOAD_EVENT.UPLOAD_SESSION, {
      ...uploadSessionEvent,
      location: this.location
    });
  }
}
exports.FileUploadTelemetryService = FileUploadTelemetryService;