"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.legendConfigFunction = void 0;
var _charts = require("@elastic/charts");
var _i18n = require("@kbn/i18n");
var _chartExpressionsCommon = require("@kbn/chart-expressions-common");
var _constants = require("../constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const legendConfigFunction = exports.legendConfigFunction = {
  name: _constants.LEGEND_CONFIG,
  aliases: [],
  type: _constants.LEGEND_CONFIG,
  help: _i18n.i18n.translate('expressionXY.legendConfig.help', {
    defaultMessage: `Configure the xy chart's legend`
  }),
  inputTypes: ['null'],
  args: {
    isVisible: {
      types: ['boolean'],
      help: _i18n.i18n.translate('expressionXY.legendConfig.isVisible.help', {
        defaultMessage: 'Specifies whether or not the legend is visible.'
      }),
      default: true
    },
    position: {
      types: ['string'],
      options: [_charts.Position.Top, _charts.Position.Right, _charts.Position.Bottom, _charts.Position.Left],
      help: _i18n.i18n.translate('expressionXY.legendConfig.position.help', {
        defaultMessage: 'Specifies the legend position.'
      }),
      strict: true
    },
    showSingleSeries: {
      types: ['boolean'],
      help: _i18n.i18n.translate('expressionXY.legendConfig.showSingleSeries.help', {
        defaultMessage: 'Specifies whether a legend with just a single entry should be shown'
      })
    },
    isInside: {
      types: ['boolean'],
      help: _i18n.i18n.translate('expressionXY.legendConfig.isInside.help', {
        defaultMessage: 'Specifies whether a legend is inside the chart'
      })
    },
    horizontalAlignment: {
      types: ['string'],
      options: [_charts.HorizontalAlignment.Right, _charts.HorizontalAlignment.Left],
      help: _i18n.i18n.translate('expressionXY.legendConfig.horizontalAlignment.help', {
        defaultMessage: 'Specifies the horizontal alignment of the legend when it is displayed inside chart.'
      }),
      strict: true
    },
    verticalAlignment: {
      types: ['string'],
      options: [_charts.VerticalAlignment.Top, _charts.VerticalAlignment.Bottom],
      help: _i18n.i18n.translate('expressionXY.legendConfig.verticalAlignment.help', {
        defaultMessage: 'Specifies the vertical alignment of the legend when it is displayed inside chart.'
      }),
      strict: true
    },
    floatingColumns: {
      types: ['number'],
      help: _i18n.i18n.translate('expressionXY.legendConfig.floatingColumns.help', {
        defaultMessage: 'Specifies the number of columns when legend is displayed inside chart.'
      })
    },
    maxLines: {
      types: ['number'],
      help: _i18n.i18n.translate('expressionXY.legendConfig.maxLines.help', {
        defaultMessage: 'Specifies the number of lines per legend item.'
      })
    },
    shouldTruncate: {
      types: ['boolean'],
      default: true,
      help: _i18n.i18n.translate('expressionXY.legendConfig.shouldTruncate.help', {
        defaultMessage: 'Specifies whether the legend items will be truncated or not'
      })
    },
    legendSize: {
      types: ['string'],
      help: _i18n.i18n.translate('expressionXY.legendConfig.legendSize.help', {
        defaultMessage: 'Specifies the legend size.'
      }),
      options: [_chartExpressionsCommon.LegendSize.AUTO, _chartExpressionsCommon.LegendSize.SMALL, _chartExpressionsCommon.LegendSize.MEDIUM, _chartExpressionsCommon.LegendSize.LARGE, _chartExpressionsCommon.LegendSize.EXTRA_LARGE],
      strict: true
    },
    legendStats: {
      types: ['string'],
      multi: true,
      help: _i18n.i18n.translate('expressionXY.legendConfig.legendStats.help', {
        defaultMessage: 'Specifies the legend stats.'
      })
    },
    title: {
      types: ['string'],
      help: _i18n.i18n.translate('expressionXY.legendConfig.title.help', {
        defaultMessage: 'Specifies the legend title.'
      })
    },
    isTitleVisible: {
      types: ['boolean'],
      help: _i18n.i18n.translate('expressionXY.legendConfig.isTitleVisible.help', {
        defaultMessage: 'Specifies if the legend title is visible.'
      })
    },
    layout: {
      types: ['string'],
      help: _i18n.i18n.translate('expressionXY.legendConfig.legendLayout.help', {
        defaultMessage: 'Specifies the legend layout.'
      }),
      options: [_chartExpressionsCommon.LegendLayout.Table, _chartExpressionsCommon.LegendLayout.List],
      strict: true
    }
  },
  async fn(input, args, handlers) {
    const {
      legendConfigFn
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./expression_module')));
    return await legendConfigFn(input, args, handlers);
  }
};