"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSeriesToEdit = exports.SeriesEditor = exports.SELECT_REPORT_TYPE = exports.REPORT_TYPE_LABEL = exports.REPORT_TYPE_ARIA_LABEL = exports.LOADING_VIEW = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _polished = require("polished");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _use_series_storage = require("../hooks/use_series_storage");
var _use_app_data_view = require("../hooks/use_app_data_view");
var _default_configs = require("../configurations/default_configs");
var _report_type_select = require("./columns/report_type_select");
var _view_actions = require("../views/view_actions");
var _series = require("./series");
var _exploratory_view_config = require("../contexts/exploratory_view_config");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/exploratory_view/public/components/shared/exploratory_view/series_editor/series_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getSeriesToEdit = ({
  dataViews,
  allSeries,
  reportType,
  reportConfigMap
}) => {
  const getDataViewSeries = dataType => {
    if (dataViews !== null && dataViews !== void 0 && dataViews[dataType]) {
      return (0, _default_configs.getDefaultConfigs)({
        dataType,
        reportType,
        reportConfigMap,
        dataView: dataViews[dataType]
      });
    }
  };
  return allSeries.map((series, seriesIndex) => {
    const seriesConfig = getDataViewSeries(series.dataType);
    return {
      id: seriesIndex,
      series,
      seriesConfig
    };
  });
};
exports.getSeriesToEdit = getSeriesToEdit;
const SeriesEditor = exports.SeriesEditor = /*#__PURE__*/_react.default.memo(function () {
  const [editorItems, setEditorItems] = (0, _react.useState)([]);
  const {
    getSeries,
    allSeries,
    reportType
  } = (0, _use_series_storage.useSeriesStorage)();
  const {
    loading,
    dataViews
  } = (0, _use_app_data_view.useAppDataViewContext)();
  const {
    reportConfigMap,
    setIsEditMode
  } = (0, _exploratory_view_config.useExploratoryView)();
  const [itemIdToExpandedRowMap, setItemIdToExpandedRowMap] = (0, _react.useState)({});
  const [{
    prevCount,
    curCount
  }, setSeriesCount] = (0, _react.useState)({
    curCount: allSeries.length
  });
  (0, _react.useEffect)(() => {
    setIsEditMode === null || setIsEditMode === void 0 ? void 0 : setIsEditMode(Object.keys(itemIdToExpandedRowMap).length > 0);
  }, [itemIdToExpandedRowMap, setIsEditMode]);
  (0, _react.useEffect)(() => {
    setSeriesCount(oldParams => ({
      prevCount: oldParams.curCount,
      curCount: allSeries.length
    }));
    if (typeof prevCount !== 'undefined' && !isNaN(prevCount) && prevCount < curCount) {
      setItemIdToExpandedRowMap({});
    }
  }, [allSeries.length, curCount, prevCount]);
  (0, _react.useEffect)(() => {
    const newExpandRows = {};
    setEditorItems(prevState => {
      const newEditorItems = getSeriesToEdit({
        reportType,
        allSeries,
        dataViews,
        reportConfigMap
      });
      newEditorItems.forEach(({
        series,
        id
      }) => {
        const prevSeriesItem = prevState.find(({
          id: prevId
        }) => prevId === id);
        if (prevSeriesItem && series.selectedMetricField && prevSeriesItem.series.selectedMetricField !== series.selectedMetricField) {
          newExpandRows[id] = true;
        }
      });
      return [...newEditorItems];
    });
    setItemIdToExpandedRowMap(prevState => {
      return {
        ...prevState,
        ...newExpandRows
      };
    });
  }, [allSeries, getSeries, dataViews, loading, reportConfigMap, reportType]);
  const toggleDetails = item => {
    const itemIdToExpandedRowMapValues = {
      ...itemIdToExpandedRowMap
    };
    if (itemIdToExpandedRowMapValues[item.id]) {
      delete itemIdToExpandedRowMapValues[item.id];
    } else {
      itemIdToExpandedRowMapValues[item.id] = true;
    }
    setItemIdToExpandedRowMap(itemIdToExpandedRowMapValues);
  };
  return /*#__PURE__*/_react.default.createElement(Wrapper, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(SectionHeaderBackground, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(StickyFlexGroup, {
    gutterSize: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    css: {
      alignItems: 'center'
    },
    "aria-label": REPORT_TYPE_ARIA_LABEL,
    id: "report-type-label",
    isDisabled: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_report_type_select.ReportTypesSelect, {
    prepend: REPORT_TYPE_LABEL,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_view_actions.ViewActions, {
    onApply: () => setItemIdToExpandedRowMap({}),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(EditorRowsWrapper, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 7
    }
  }, editorItems.map((item, index) => /*#__PURE__*/_react.default.createElement("div", {
    key: item.id,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_series.Series, {
    item: item,
    toggleExpanded: () => toggleDetails(item),
    isExpanded: itemIdToExpandedRowMap[item.id],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 13
    }
  }), index + 1 !== editorItems.length && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 50
    }
  })))));
});
const Wrapper = _styled.default.div`
  &::-webkit-scrollbar {
    height: ${({
  theme
}) => theme.euiTheme.size.base};
    width: ${({
  theme
}) => theme.euiTheme.size.base};
  }
  &::-webkit-scrollbar-thumb {
    background-clip: content-box;
    background-color: ${({
  theme
}) => (0, _polished.rgba)(theme.euiTheme.colors.darkShade, 0.5)};
    border: ${({
  theme
}) => theme.euiTheme.border.radius.small} solid transparent;
  }
  &::-webkit-scrollbar-corner,
  &::-webkit-scrollbar-track {
    background-color: transparent;
  }

  &&& {
    .euiTableRow-isExpandedRow .euiTableRowCell {
      border-top: none;
      background-color: #ffffff;
      border-bottom: 2px solid #d3dae6;
      border-right: 2px solid rgb(211, 218, 230);
      border-left: 2px solid rgb(211, 218, 230);
    }

    .isExpanded {
      border-right: 2px solid rgb(211, 218, 230);
      border-left: 2px solid rgb(211, 218, 230);
      .euiTableRowCell {
        border-bottom: none;
      }
    }
    .isIncomplete .euiTableRowCell {
      background-color: rgba(254, 197, 20, 0.1);
    }
  }
`;
const SectionHeaderBackground = _styled.default.div`
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 56px;
  background-color: ${({
  theme
}) => theme.euiTheme.colors.body};
  border-bottom: 1px solid ${({
  theme
}) => theme.euiTheme.colors.lightShade};
  z-index: 90;
`;
const StickyFlexGroup = (0, _styled.default)(_eui.EuiFlexGroup)`
  position: sticky;
  top: 0;
  z-index: 100;
  padding: 0;
`;
const EditorRowsWrapper = _styled.default.div`
  margin: ${({
  theme
}) => theme.euiTheme.size.m} 0;
`;
const LOADING_VIEW = exports.LOADING_VIEW = _i18n.i18n.translate('xpack.exploratoryView.expView.seriesBuilder.loadingView', {
  defaultMessage: 'Loading view ...'
});
const SELECT_REPORT_TYPE = exports.SELECT_REPORT_TYPE = _i18n.i18n.translate('xpack.exploratoryView.expView.seriesBuilder.selectReportType', {
  defaultMessage: 'No report type selected'
});
const REPORT_TYPE_LABEL = exports.REPORT_TYPE_LABEL = _i18n.i18n.translate('xpack.exploratoryView.expView.seriesBuilder.reportType', {
  defaultMessage: 'Report type'
});
const REPORT_TYPE_ARIA_LABEL = exports.REPORT_TYPE_ARIA_LABEL = _i18n.i18n.translate('xpack.exploratoryView.expView.seriesBuilder.reportType.aria', {
  defaultMessage: 'This select allows you to choose the type of report you wish to create'
});