"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.detectCategory = detectCategory;
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function detectCategory(item) {
  const {
    category,
    kind
  } = item;
  if (category) {
    if (Object.values(_types.SuggestionCategory).includes(category)) {
      return category;
    }
  }
  if (kind === 'Operator') {
    return _types.SuggestionCategory.OPERATOR;
  }
  return _types.SuggestionCategory.UNKNOWN;
}