"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCurrentQueryAvailableColumns = getCurrentQueryAvailableColumns;
exports.getFieldsFromES = getFieldsFromES;
var _ = require("../..");
var _enrich_fields_with_ecs = require("./enrich_fields_with_ecs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function getEcsMetadata(resourceRetriever) {
  if (!(resourceRetriever !== null && resourceRetriever !== void 0 && resourceRetriever.getFieldsMetadata)) {
    return undefined;
  }
  const client = await (resourceRetriever === null || resourceRetriever === void 0 ? void 0 : resourceRetriever.getFieldsMetadata);
  if (client.find) {
    // Fetch full list of ECS field
    // This list should be cached already by fieldsMetadataClient
    const results = await client.find({
      attributes: ['type']
    });
    return results === null || results === void 0 ? void 0 : results.fields;
  }
}
function createGetJoinFields(fetchFields) {
  return command => {
    const joinSummary = _.mutate.commands.join.summarize({
      type: 'query',
      commands: [command]
    });
    const joinIndices = joinSummary.map(({
      target: {
        index
      }
    }) => index);
    if (joinIndices.length > 0) {
      const joinFieldQuery = _.synth.cmd`FROM ${joinIndices}`.toString();
      return fetchFields(joinFieldQuery);
    }
    return Promise.resolve([]);
  };
}
function createGetEnrichFields(fetchFields, getPolicies) {
  return async command => {
    if (!(0, _.isSource)(command.args[0])) {
      return [];
    }
    const policyName = command.args[0].name;
    const policies = await getPolicies();
    const policy = policies.get(policyName);
    if (policy) {
      const fieldsQuery = `FROM ${policy.sourceIndices.join(', ')} | KEEP ${policy.enrichFields.join(', ')}`;
      return fetchFields(fieldsQuery);
    }
    return [];
  };
}
function createGetFromFields(fetchFields) {
  return command => {
    return fetchFields(_.BasicPrettyPrinter.command(command));
  };
}
// Get the fields from the FROM clause, enrich them with ECS metadata
async function getFieldsFromES(query, resourceRetriever) {
  var _resourceRetriever$ge;
  const metadata = await getEcsMetadata(resourceRetriever);
  const fieldsOfType = await (resourceRetriever === null || resourceRetriever === void 0 ? void 0 : (_resourceRetriever$ge = resourceRetriever.getColumnsFor) === null || _resourceRetriever$ge === void 0 ? void 0 : _resourceRetriever$ge.call(resourceRetriever, {
    query
  }));
  const fieldsWithMetadata = (0, _enrich_fields_with_ecs.enrichFieldsWithECSInfo)(fieldsOfType || [], metadata);
  return fieldsWithMetadata;
}

/**
 * @param query, the ES|QL query
 * @param commands, the AST commands
 * @param previousPipeFields, the fields from the previous pipe
 * @returns a list of fields that are available for the current pipe
 */
async function getCurrentQueryAvailableColumns(commands, previousPipeFields, fetchFields, getPolicies, originalQueryText) {
  if (commands.length === 0) {
    return previousPipeFields;
  }
  const lastCommand = commands[commands.length - 1];
  const commandDef = _.esqlCommandRegistry.getCommandByName(lastCommand.name);
  if (!(commandDef !== null && commandDef !== void 0 && commandDef.methods.columnsAfter)) {
    return previousPipeFields;
  }
  const getJoinFields = createGetJoinFields(fetchFields);
  const getEnrichFields = createGetEnrichFields(fetchFields, getPolicies);
  const getFromFields = createGetFromFields(fetchFields);
  const additionalFields = {
    fromJoin: getJoinFields,
    fromEnrich: getEnrichFields,
    fromFrom: getFromFields
  };
  if (commandDef !== null && commandDef !== void 0 && commandDef.methods.columnsAfter) {
    return commandDef.methods.columnsAfter(lastCommand, previousPipeFields, originalQueryText, additionalFields);
  }
  return previousPipeFields;
}