"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.autocomplete = autocomplete;
var _i18n = require("@kbn/i18n");
var _helpers = require("../../definitions/utils/autocomplete/helpers");
var _complete_items = require("../complete_items");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function autocomplete(query, command, callbacks, context, cursorPosition) {
  const innerText = query.substring(0, cursorPosition);
  // SHOW INFO /
  if (/INFO\s+$/i.test(innerText)) {
    return [(0, _helpers.withAutoSuggest)(_complete_items.pipeCompleteItem)];
  }
  // SHOW LOLZ /
  else if (/SHOW\s+\S+\s+$/i.test(innerText)) {
    return [];
  }
  // SHOW /
  return [{
    text: 'INFO',
    detail: _i18n.i18n.translate('kbn-esql-ast.esql.show.info.detail', {
      defaultMessage: 'Get information about the Elasticsearch cluster.'
    }),
    kind: 'Method',
    label: 'INFO'
  }];
}