"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.columnsAfter = void 0;
var _walker = require("../../../ast/walker");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const columnsAfter = (command, previousColumns, query) => {
  const columnsToKeep = [];
  (0, _walker.walk)(command, {
    visitColumn: node => {
      columnsToKeep.push(node.parts.join('.'));
    }
  });
  return previousColumns.filter(field => {
    return columnsToKeep.some(column => column === field.name);
  });
};
exports.columnsAfter = columnsAfter;