"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.columnsAfter = void 0;
var _lodash = require("lodash");
var _is = require("../../../ast/is");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const columnsAfter = async (command, previousColumns, query, additionalFields) => {
  const enrichFields = await additionalFields.fromEnrich(command);
  let fieldsToAdd = enrichFields;

  // the with option scopes down the fields that are added
  // and potentially renames things
  const withOption = command.args.find(arg => (0, _is.isOptionNode)(arg) && arg.name === 'with');
  if (withOption) {
    const declaredFieldEntries = withOption.args.map(arg => {
      if ((0, _is.isAssignment)(arg) && (0, _is.isColumn)(arg.args[0]) && Array.isArray(arg.args[1]) && (0, _is.isColumn)(arg.args[1][0])) {
        return [arg.args[1][0].parts.join('.'), arg.args[0].parts.join('.')];
      }
      return undefined;
    }).filter(Boolean);
    const declaredFields = new Map(declaredFieldEntries);
    fieldsToAdd = enrichFields.filter(field => declaredFields.has(field.name)).map(field => {
      const newName = declaredFields.get(field.name);
      return {
        ...field,
        name: newName
      };
    });
  }
  return (0, _lodash.uniqBy)([...fieldsToAdd, ...previousColumns], 'name');
};
exports.columnsAfter = columnsAfter;