"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withMapCompleteItem = exports.withCompleteItem = exports.whereCompleteItem = exports.valuePlaceholderConstant = exports.subqueryCompleteItem = exports.semiColonCompleteItem = exports.rlikePatternItems = exports.pipeCompleteItem = exports.onCompleteItem = exports.noneValueCompleteItem = exports.minMaxValueCompleteItem = exports.listCompleteItem = exports.likePatternItems = exports.getNewUserDefinedColumnSuggestion = exports.getDateHistogramCompletionItem = exports.getCommandAutocompleteDefinitions = exports.defaultValuePlaceholderConstant = exports.commaCompleteItem = exports.colonCompleteItem = exports.byCompleteItem = exports.assignCompletionItem = exports.asCompletionItem = exports.allStarConstant = void 0;
var _i18n = require("@kbn/i18n");
var _ = require(".");
var _documentation = require("../definitions/utils/documentation");
var _literals = require("../definitions/utils/literals");
var _helpers = require("../definitions/utils/autocomplete/helpers");
var _types = require("../../shared/sorting/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const techPreviewLabel = _i18n.i18n.translate('kbn-esql-ast.esql.autocomplete.techPreviewLabel', {
  defaultMessage: `Technical Preview`
});
function buildCharCompleteItem(label, detail, {
  sortText,
  quoted,
  advanceCursorAndOpenSuggestions,
  category
} = {
  quoted: false
}) {
  const suggestion = {
    label,
    text: (quoted ? `"${label}"` : label) + (advanceCursorAndOpenSuggestions ? ' ' : ''),
    kind: 'Keyword',
    detail,
    sortText,
    ...(category && {
      category
    })
  };
  return advanceCursorAndOpenSuggestions ? (0, _helpers.withAutoSuggest)(suggestion) : suggestion;
}
const pipeCompleteItem = exports.pipeCompleteItem = (0, _helpers.withAutoSuggest)({
  label: '|',
  text: '| ',
  kind: 'Keyword',
  detail: _i18n.i18n.translate('kbn-esql-ast.esql.autocomplete.pipeDoc', {
    defaultMessage: 'Pipe (|)'
  }),
  sortText: 'C',
  category: _types.SuggestionCategory.PIPE
});
const allStarConstant = exports.allStarConstant = {
  label: _i18n.i18n.translate('kbn-esql-ast.esql.autocomplete.allStarConstantDoc', {
    defaultMessage: 'All (*)'
  }),
  text: '*',
  kind: 'Constant',
  detail: _i18n.i18n.translate('kbn-esql-ast.esql.autocomplete.allStarConstantDoc', {
    defaultMessage: 'All (*)'
  }),
  sortText: '1',
  category: _types.SuggestionCategory.CONSTANT_VALUE
};
function buildValuePlaceholder(placeholderType = 'value') {
  return (0, _helpers.withAutoSuggest)({
    label: _i18n.i18n.translate('kbn-esql-ast.esql.autocomplete.valuePlaceholderLabel', {
      defaultMessage: 'Insert {placeholderType} placeholder',
      values: {
        placeholderType
      }
    }),
    text: `"\${0:${placeholderType}}"`,
    asSnippet: true,
    kind: 'Constant',
    detail: _i18n.i18n.translate('kbn-esql-ast.esql.autocomplete.valuePlaceholderDetail', {
      defaultMessage: 'Insert a {placeholderType} to describe the condition',
      values: {
        placeholderType
      }
    }),
    category: _types.SuggestionCategory.CONSTANT_VALUE
  });
}
const valuePlaceholderConstant = exports.valuePlaceholderConstant = buildValuePlaceholder('value');
const defaultValuePlaceholderConstant = exports.defaultValuePlaceholderConstant = buildValuePlaceholder('default');
const commaCompleteItem = exports.commaCompleteItem = buildCharCompleteItem(',', _i18n.i18n.translate('kbn-esql-ast.esql.autocomplete.commaDoc', {
  defaultMessage: 'Comma (,)'
}), {
  sortText: 'B',
  quoted: false,
  category: _types.SuggestionCategory.COMMA
});
const byCompleteItem = exports.byCompleteItem = (0, _helpers.withAutoSuggest)({
  label: 'BY',
  text: 'BY ',
  kind: 'Reference',
  detail: 'By',
  sortText: '1',
  category: _types.SuggestionCategory.LANGUAGE_KEYWORD
});
const whereCompleteItem = exports.whereCompleteItem = (0, _helpers.withAutoSuggest)({
  label: 'WHERE',
  text: 'WHERE ',
  kind: 'Reference',
  detail: 'Where',
  sortText: '1',
  category: _types.SuggestionCategory.LANGUAGE_KEYWORD
});
const onCompleteItem = exports.onCompleteItem = (0, _helpers.withAutoSuggest)({
  label: 'ON',
  text: 'ON ',
  kind: 'Reference',
  detail: 'On',
  sortText: '1',
  category: _types.SuggestionCategory.LANGUAGE_KEYWORD
});
const withCompleteItem = exports.withCompleteItem = (0, _helpers.withAutoSuggest)({
  label: 'WITH',
  text: 'WITH { $0 }',
  asSnippet: true,
  kind: 'Reference',
  detail: 'With',
  sortText: '1',
  category: _types.SuggestionCategory.LANGUAGE_KEYWORD
});
const withMapCompleteItem = exports.withMapCompleteItem = (0, _helpers.withAutoSuggest)({
  label: 'inference_id',
  text: '{ "inference_id": "$0" }',
  asSnippet: true,
  kind: 'Reference',
  detail: 'Inference endpoint',
  sortText: '1'
});
const subqueryCompleteItem = exports.subqueryCompleteItem = (0, _helpers.withAutoSuggest)({
  label: '(FROM ...)',
  text: '(FROM $0)',
  asSnippet: true,
  kind: 'Method',
  detail: _i18n.i18n.translate('kbn-esql-ast.esql.autocomplete.subqueryFromDoc', {
    defaultMessage: 'Adds a nested ES|QL query to your current query'
  }),
  sortText: '1',
  category: _types.SuggestionCategory.CUSTOM_ACTION
});
const minMaxValueCompleteItem = exports.minMaxValueCompleteItem = {
  label: 'minmax',
  text: 'minmax',
  kind: 'Value',
  detail: 'minmax',
  sortText: '1',
  category: _types.SuggestionCategory.VALUE
};
const noneValueCompleteItem = exports.noneValueCompleteItem = {
  label: 'none',
  text: 'none',
  kind: 'Value',
  detail: 'none',
  sortText: '1',
  category: _types.SuggestionCategory.VALUE
};
const getNewUserDefinedColumnSuggestion = label => {
  return (0, _helpers.withAutoSuggest)({
    label,
    text: `${label} = `,
    kind: 'Variable',
    detail: _i18n.i18n.translate('kbn-esql-ast.esql.autocomplete.newVarDoc', {
      defaultMessage: 'Define a new column'
    }),
    sortText: '1',
    category: _types.SuggestionCategory.USER_DEFINED_COLUMN
  });
};
exports.getNewUserDefinedColumnSuggestion = getNewUserDefinedColumnSuggestion;
const assignCompletionItem = exports.assignCompletionItem = (0, _helpers.withAutoSuggest)({
  detail: _i18n.i18n.translate('kbn-esql-ast.esql.autocomplete.newVarDoc', {
    defaultMessage: 'Define a new column'
  }),
  label: '=',
  kind: 'Variable',
  sortText: '1',
  text: '= ',
  category: _types.SuggestionCategory.USER_DEFINED_COLUMN
});
const asCompletionItem = exports.asCompletionItem = {
  detail: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.asDoc', {
    defaultMessage: 'As'
  }),
  kind: 'Reference',
  label: 'AS',
  sortText: '1',
  text: 'AS ',
  category: _types.SuggestionCategory.LANGUAGE_KEYWORD
};
const colonCompleteItem = exports.colonCompleteItem = buildCharCompleteItem(':', _i18n.i18n.translate('kbn-esql-ast.esql.autocomplete.colonDoc', {
  defaultMessage: 'Colon (:)'
}), {
  sortText: 'A',
  quoted: true,
  advanceCursorAndOpenSuggestions: true
});
const semiColonCompleteItem = exports.semiColonCompleteItem = buildCharCompleteItem(';', _i18n.i18n.translate('kbn-esql-ast.esql.autocomplete.semiColonDoc', {
  defaultMessage: 'Semi colon (;)'
}), {
  sortText: 'A',
  quoted: true,
  advanceCursorAndOpenSuggestions: true
});
const listCompleteItem = exports.listCompleteItem = (0, _helpers.withAutoSuggest)({
  label: '( ... )',
  text: '($0)',
  asSnippet: true,
  kind: 'Operator',
  detail: _i18n.i18n.translate('kbn-esql-ast.esql.autocomplete.listDoc', {
    defaultMessage: 'List of items ( ...)'
  }),
  sortText: 'A'
});
const likePatternItems = exports.likePatternItems = [{
  label: '*',
  text: '"${0:*}"',
  asSnippet: true,
  kind: 'Value',
  detail: _i18n.i18n.translate('kbn-esql-ast.esql.autocomplete.likeAsteriskDoc', {
    defaultMessage: 'Matches any sequence of zero or more characters'
  }),
  sortText: '1'
}, {
  label: '?',
  text: '"${0:?}"',
  asSnippet: true,
  kind: 'Value',
  detail: _i18n.i18n.translate('kbn-esql-ast.esql.autocomplete.likeQuestionMarkDoc', {
    defaultMessage: 'Matches any single character'
  }),
  sortText: '1'
}];
const rlikePatternItems = exports.rlikePatternItems = [{
  label: '.*',
  text: '"${0:.*}"',
  asSnippet: true,
  kind: 'Value',
  detail: _i18n.i18n.translate('kbn-esql-ast.esql.autocomplete.rlikeAnyStringDoc', {
    defaultMessage: 'Matches any sequence of zero or more characters'
  }),
  sortText: '1'
}, {
  label: '.',
  text: '"${0:.}"',
  asSnippet: true,
  kind: 'Value',
  detail: _i18n.i18n.translate('kbn-esql-ast.esql.autocomplete.rlikeAnySingleCharDoc', {
    defaultMessage: 'Matches any single character'
  }),
  sortText: '1'
}, {
  label: '^',
  text: '"${0:^}"',
  asSnippet: true,
  kind: 'Value',
  detail: _i18n.i18n.translate('kbn-esql-ast.esql.autocomplete.rlikeStartAnchorDoc', {
    defaultMessage: 'Match to the start of the string'
  }),
  sortText: '1'
}, {
  label: '$',
  text: '"${0:$}"',
  asSnippet: true,
  kind: 'Value',
  detail: _i18n.i18n.translate('kbn-esql-ast.esql.autocomplete.rlikeEndAnchorDoc', {
    defaultMessage: 'Match to the end of the string'
  }),
  sortText: '1'
}];
const getCommandAutocompleteDefinitions = commands => {
  const suggestions = [];
  for (const command of commands) {
    var _commandDefinition$me, _commandDefinition$me2, _commandDefinition$me3;
    const commandDefinition = _.esqlCommandRegistry.getCommandByName(command);
    if (commandDefinition !== null && commandDefinition !== void 0 && (_commandDefinition$me = commandDefinition.metadata) !== null && _commandDefinition$me !== void 0 && _commandDefinition$me.hidden || !commandDefinition) {
      continue;
    }
    const label = commandDefinition.name.toUpperCase();
    const text = `${commandDefinition.name.toUpperCase()} `;
    const types = (_commandDefinition$me2 = (_commandDefinition$me3 = commandDefinition.metadata) === null || _commandDefinition$me3 === void 0 ? void 0 : _commandDefinition$me3.types) !== null && _commandDefinition$me2 !== void 0 ? _commandDefinition$me2 : [{
      name: '',
      description: ''
    }];
    for (const type of types) {
      let detail = type.description || commandDefinition.metadata.description;
      if (commandDefinition.metadata.preview) {
        detail = `**[${techPreviewLabel}]** ${detail}`;
      }
      const suggestion = (0, _helpers.withAutoSuggest)({
        label: type.name ? `${type.name.toLocaleUpperCase()} ${label}` : label,
        text: type.name ? `${type.name.toLocaleUpperCase()} ${text}` : text,
        kind: 'Method',
        documentation: {
          value: (0, _documentation.buildDocumentation)(detail, commandDefinition.metadata.declaration, commandDefinition.metadata.examples)
        },
        sortText: 'A-' + label + '-' + type.name
      });
      suggestions.push(suggestion);
    }
  }
  return suggestions;
};
exports.getCommandAutocompleteDefinitions = getCommandAutocompleteDefinitions;
const getDateHistogramCompletionItem = (histogramBarTarget = 50) => (0, _helpers.withAutoSuggest)({
  label: _i18n.i18n.translate('kbn-esql-ast.esql.autocomplete.addDateHistogram', {
    defaultMessage: 'Add date histogram'
  }),
  text: `BUCKET($0, ${histogramBarTarget}, ${_literals.TIME_SYSTEM_PARAMS.join(', ')})`,
  asSnippet: true,
  kind: 'Issue',
  detail: _i18n.i18n.translate('kbn-esql-ast.esql.autocomplete.addDateHistogramDetail', {
    defaultMessage: 'Add date histogram using bucket()'
  }),
  sortText: '1',
  category: _types.SuggestionCategory.CUSTOM_ACTION
});
exports.getDateHistogramCompletionItem = getDateHistogramCompletionItem;