"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildValueDefinitions = void 0;
var _i18n = require("@kbn/i18n");
var _helpers = require("./autocomplete/helpers");
var _types = require("../../../shared/sorting/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const buildValueDefinitions = (values, options) => values.map(value => {
  const suggestion = {
    label: `"${value}"`,
    text: `"${value}"${options !== null && options !== void 0 && options.addComma ? ',' : ''}${options !== null && options !== void 0 && options.advanceCursorAndOpenSuggestions ? ' ' : ''}`,
    detail: _i18n.i18n.translate('kbn-esql-ast.esql.autocomplete.valueDefinition', {
      defaultMessage: 'Literal value'
    }),
    kind: 'Value',
    category: _types.SuggestionCategory.VALUE
  };
  return options !== null && options !== void 0 && options.advanceCursorAndOpenSuggestions ? (0, _helpers.withAutoSuggest)(suggestion) : suggestion;
});
exports.buildValueDefinitions = buildValueDefinitions;