"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SuggestionBuilder = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _helpers = require("../helpers");
var _operators = require("../../operators");
var _complete_items = require("../../../../registry/complete_items");
var _comma_decision_engine = require("./comma_decision_engine");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/** Builder pattern to eliminate duplicated field/function/literal suggestion code. */
class SuggestionBuilder {
  constructor(context) {
    (0, _defineProperty2.default)(this, "suggestions", []);
    (0, _defineProperty2.default)(this, "context", void 0);
    this.context = context;
  }
  async addFields(options) {
    var _options$types, _options$addComma, _options$addSpaceAfte, _options$promoteToTop, _options$ignoredColum, _options$openSuggesti, _options$canBeMultiVa, _this$context$callbac, _this$context$callbac2;
    const types = (_options$types = options === null || options === void 0 ? void 0 : options.types) !== null && _options$types !== void 0 ? _options$types : ['any'];
    const addComma = (_options$addComma = options === null || options === void 0 ? void 0 : options.addComma) !== null && _options$addComma !== void 0 ? _options$addComma : false;
    const addSpaceAfterField = (_options$addSpaceAfte = options === null || options === void 0 ? void 0 : options.addSpaceAfterField) !== null && _options$addSpaceAfte !== void 0 ? _options$addSpaceAfte : addComma;
    const promoteToTop = (_options$promoteToTop = options === null || options === void 0 ? void 0 : options.promoteToTop) !== null && _options$promoteToTop !== void 0 ? _options$promoteToTop : true;
    const ignoredColumns = (_options$ignoredColum = options === null || options === void 0 ? void 0 : options.ignoredColumns) !== null && _options$ignoredColum !== void 0 ? _options$ignoredColum : [];
    const openSuggestions = (_options$openSuggesti = options === null || options === void 0 ? void 0 : options.openSuggestions) !== null && _options$openSuggesti !== void 0 ? _options$openSuggesti : addSpaceAfterField || addComma;
    const values = options === null || options === void 0 ? void 0 : options.values;
    const canBeMultiValue = (_options$canBeMultiVa = options === null || options === void 0 ? void 0 : options.canBeMultiValue) !== null && _options$canBeMultiVa !== void 0 ? _options$canBeMultiVa : false;
    const getByType = (_this$context$callbac = (_this$context$callbac2 = this.context.callbacks) === null || _this$context$callbac2 === void 0 ? void 0 : _this$context$callbac2.getByType) !== null && _this$context$callbac !== void 0 ? _this$context$callbac : () => Promise.resolve([]);
    const fieldSuggestions = await (0, _helpers.getFieldsSuggestions)(types, getByType, {
      ignoreColumns: ignoredColumns,
      addSpaceAfterField,
      openSuggestions,
      addComma,
      promoteToTop,
      values,
      canBeMultiValue
    });
    this.suggestions.push(...fieldSuggestions);
    return this;
  }
  addFunctions(options) {
    var _options$types2, _options$ignoredFunct, _options$constantGene, _this$context$callbac3;
    const types = (_options$types2 = options === null || options === void 0 ? void 0 : options.types) !== null && _options$types2 !== void 0 ? _options$types2 : ['any'];
    const ignored = (_options$ignoredFunct = options === null || options === void 0 ? void 0 : options.ignoredFunctions) !== null && _options$ignoredFunct !== void 0 ? _options$ignoredFunct : [];
    const addSpaceAfterFunction = options === null || options === void 0 ? void 0 : options.addSpaceAfterFunction;
    const openSuggestions = options === null || options === void 0 ? void 0 : options.openSuggestions;
    const constantGeneratingOnly = (_options$constantGene = options === null || options === void 0 ? void 0 : options.constantGeneratingOnly) !== null && _options$constantGene !== void 0 ? _options$constantGene : false;
    const functionSuggestions = (0, _helpers.getFunctionsSuggestions)({
      location: this.context.location,
      types,
      options: {
        ignored,
        addComma: options === null || options === void 0 ? void 0 : options.addComma,
        addSpaceAfterFunction,
        openSuggestions,
        constantGeneratingOnly
      },
      context: this.context.context,
      callbacks: {
        hasMinimumLicenseRequired: (_this$context$callbac3 = this.context.callbacks) === null || _this$context$callbac3 === void 0 ? void 0 : _this$context$callbac3.hasMinimumLicenseRequired
      }
    });
    this.suggestions.push(...functionSuggestions);
    return this;
  }
  addLiterals(options) {
    var _options$types3, _options$includeDateL, _options$includeCompa, _options$advanceCurso, _this$context$context, _this$context$context2;
    const types = (_options$types3 = options === null || options === void 0 ? void 0 : options.types) !== null && _options$types3 !== void 0 ? _options$types3 : ['any'];
    const includeDateLiterals = (_options$includeDateL = options === null || options === void 0 ? void 0 : options.includeDateLiterals) !== null && _options$includeDateL !== void 0 ? _options$includeDateL : true;
    const includeCompatibleLiterals = (_options$includeCompa = options === null || options === void 0 ? void 0 : options.includeCompatibleLiterals) !== null && _options$includeCompa !== void 0 ? _options$includeCompa : true;
    const advanceCursorAndOpenSuggestions = (_options$advanceCurso = options === null || options === void 0 ? void 0 : options.advanceCursorAndOpenSuggestions) !== null && _options$advanceCurso !== void 0 ? _options$advanceCurso : false;
    const literals = (0, _helpers.getLiteralsSuggestions)(types, this.context.location, {
      includeDateLiterals,
      includeCompatibleLiterals,
      addComma: options === null || options === void 0 ? void 0 : options.addComma,
      advanceCursorAndOpenSuggestions,
      supportsControls: (_this$context$context = this.context.context) === null || _this$context$context === void 0 ? void 0 : _this$context$context.supportsControls,
      variables: (_this$context$context2 = this.context.context) === null || _this$context$context2 === void 0 ? void 0 : _this$context$context2.variables
    });
    this.suggestions.push(...literals);
    return this;
  }
  addOperators(options) {
    var _this$context$callbac4, _this$context$context3;
    const operatorSuggestions = (0, _operators.getOperatorSuggestions)({
      location: this.context.location,
      leftParamType: options === null || options === void 0 ? void 0 : options.leftParamType,
      allowed: options === null || options === void 0 ? void 0 : options.allowed,
      ignored: options === null || options === void 0 ? void 0 : options.ignored,
      returnTypes: options === null || options === void 0 ? void 0 : options.returnTypes
    }, (_this$context$callbac4 = this.context.callbacks) === null || _this$context$callbac4 === void 0 ? void 0 : _this$context$callbac4.hasMinimumLicenseRequired, (_this$context$context3 = this.context.context) === null || _this$context$context3 === void 0 ? void 0 : _this$context$context3.activeProduct);
    this.suggestions.push(...operatorSuggestions);
    return this;
  }

  /**
   * Adds comma suggestion based on decision engine rules.
   */
  addCommaIfNeeded(commaContext) {
    if ((0, _comma_decision_engine.shouldSuggestComma)(commaContext)) {
      this.suggestions.push(_complete_items.commaCompleteItem);
    }
    return this;
  }
  addSuggestions(suggestions) {
    this.suggestions.push(...suggestions);
    return this;
  }
  build() {
    return this.suggestions;
  }
}
exports.SuggestionBuilder = SuggestionBuilder;