"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.operatorFunctionDefinitions = void 0;
var _i18n = require("@kbn/i18n");
var _types = require("../../registry/types");
var _types2 = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * __AUTOGENERATED FILE. DO NOT EDIT THIS FILE DIRECTLY.__
 *
 * @note This file is generated by the `generate_function_definitions.ts`
 * script. Do not edit it manually.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const addDefinition = {
  type: _types2.FunctionDefinitionTypes.OPERATOR,
  name: '+',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.add', {
    defaultMessage: 'Add two numbers together. If either field is multivalued then the result is `null`.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'left',
      type: 'date',
      optional: false,
      description: 'A numeric value or a date time value.'
    }, {
      name: 'right',
      type: 'date_period',
      optional: false,
      description: 'A numeric value or a date time value.'
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'left',
      type: 'date',
      optional: false,
      description: 'A numeric value or a date time value.'
    }, {
      name: 'right',
      type: 'time_duration',
      optional: false,
      description: 'A numeric value or a date time value.'
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'left',
      type: 'date_nanos',
      optional: false,
      description: 'A numeric value or a date time value.'
    }, {
      name: 'right',
      type: 'date_period',
      optional: false,
      description: 'A numeric value or a date time value.'
    }],
    returnType: 'date_nanos'
  }, {
    params: [{
      name: 'left',
      type: 'date_nanos',
      optional: false,
      description: 'A numeric value or a date time value.'
    }, {
      name: 'right',
      type: 'time_duration',
      optional: false,
      description: 'A numeric value or a date time value.'
    }],
    returnType: 'date_nanos'
  }, {
    params: [{
      name: 'left',
      type: 'date_period',
      optional: false,
      description: 'A numeric value or a date time value.'
    }, {
      name: 'right',
      type: 'date',
      optional: false,
      description: 'A numeric value or a date time value.'
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'left',
      type: 'date_period',
      optional: false,
      description: 'A numeric value or a date time value.'
    }, {
      name: 'right',
      type: 'date_nanos',
      optional: false,
      description: 'A numeric value or a date time value.'
    }],
    returnType: 'date_nanos'
  }, {
    params: [{
      name: 'left',
      type: 'date_period',
      optional: false,
      description: 'A numeric value or a date time value.'
    }, {
      name: 'right',
      type: 'date_period',
      optional: false,
      description: 'A numeric value or a date time value.'
    }],
    returnType: 'date_period'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false,
      description: 'A numeric value or a date time value.'
    }, {
      name: 'right',
      type: 'double',
      optional: false,
      description: 'A numeric value or a date time value.'
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false,
      description: 'A numeric value or a date time value.'
    }, {
      name: 'right',
      type: 'integer',
      optional: false,
      description: 'A numeric value or a date time value.'
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false,
      description: 'A numeric value or a date time value.'
    }, {
      name: 'right',
      type: 'long',
      optional: false,
      description: 'A numeric value or a date time value.'
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false,
      description: 'A numeric value or a date time value.'
    }, {
      name: 'right',
      type: 'double',
      optional: false,
      description: 'A numeric value or a date time value.'
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false,
      description: 'A numeric value or a date time value.'
    }, {
      name: 'right',
      type: 'integer',
      optional: false,
      description: 'A numeric value or a date time value.'
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false,
      description: 'A numeric value or a date time value.'
    }, {
      name: 'right',
      type: 'long',
      optional: false,
      description: 'A numeric value or a date time value.'
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false,
      description: 'A numeric value or a date time value.'
    }, {
      name: 'right',
      type: 'double',
      optional: false,
      description: 'A numeric value or a date time value.'
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false,
      description: 'A numeric value or a date time value.'
    }, {
      name: 'right',
      type: 'integer',
      optional: false,
      description: 'A numeric value or a date time value.'
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false,
      description: 'A numeric value or a date time value.'
    }, {
      name: 'right',
      type: 'long',
      optional: false,
      description: 'A numeric value or a date time value.'
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'left',
      type: 'time_duration',
      optional: false,
      description: 'A numeric value or a date time value.'
    }, {
      name: 'right',
      type: 'date',
      optional: false,
      description: 'A numeric value or a date time value.'
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'left',
      type: 'time_duration',
      optional: false,
      description: 'A numeric value or a date time value.'
    }, {
      name: 'right',
      type: 'date_nanos',
      optional: false,
      description: 'A numeric value or a date time value.'
    }],
    returnType: 'date_nanos'
  }, {
    params: [{
      name: 'left',
      type: 'time_duration',
      optional: false,
      description: 'A numeric value or a date time value.'
    }, {
      name: 'right',
      type: 'time_duration',
      optional: false,
      description: 'A numeric value or a date time value.'
    }],
    returnType: 'time_duration'
  }, {
    params: [{
      name: 'left',
      type: 'unsigned_long',
      optional: false,
      description: 'A numeric value or a date time value.'
    }, {
      name: 'right',
      type: 'unsigned_long',
      optional: false,
      description: 'A numeric value or a date time value.'
    }],
    returnType: 'unsigned_long'
  }, {
    params: [{
      name: 'left',
      type: 'time_duration'
    }, {
      name: 'right',
      type: 'date'
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'left',
      type: 'date'
    }, {
      name: 'right',
      type: 'time_duration'
    }],
    returnType: 'date'
  }],
  locationsAvailable: [_types.Location.STATS, _types.Location.EVAL, _types.Location.WHERE, _types.Location.ROW, _types.Location.SORT, _types.Location.STATS_WHERE, _types.Location.STATS_BY, _types.Location.COMPLETION, _types.Location.RERANK, _types.Location.JOIN],
  examples: []
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const divDefinition = {
  type: _types2.FunctionDefinitionTypes.OPERATOR,
  name: '/',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.div', {
    defaultMessage: 'Divide one number by another. If either field is multivalued then the result is `null`.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'left',
      type: 'double',
      optional: false,
      description: 'A numeric value.'
    }, {
      name: 'right',
      type: 'double',
      optional: false,
      description: 'A numeric value.'
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false,
      description: 'A numeric value.'
    }, {
      name: 'right',
      type: 'integer',
      optional: false,
      description: 'A numeric value.'
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false,
      description: 'A numeric value.'
    }, {
      name: 'right',
      type: 'long',
      optional: false,
      description: 'A numeric value.'
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false,
      description: 'A numeric value.'
    }, {
      name: 'right',
      type: 'double',
      optional: false,
      description: 'A numeric value.'
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false,
      description: 'A numeric value.'
    }, {
      name: 'right',
      type: 'integer',
      optional: false,
      description: 'A numeric value.'
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false,
      description: 'A numeric value.'
    }, {
      name: 'right',
      type: 'long',
      optional: false,
      description: 'A numeric value.'
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false,
      description: 'A numeric value.'
    }, {
      name: 'right',
      type: 'double',
      optional: false,
      description: 'A numeric value.'
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false,
      description: 'A numeric value.'
    }, {
      name: 'right',
      type: 'integer',
      optional: false,
      description: 'A numeric value.'
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false,
      description: 'A numeric value.'
    }, {
      name: 'right',
      type: 'long',
      optional: false,
      description: 'A numeric value.'
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'left',
      type: 'unsigned_long',
      optional: false,
      description: 'A numeric value.'
    }, {
      name: 'right',
      type: 'unsigned_long',
      optional: false,
      description: 'A numeric value.'
    }],
    returnType: 'unsigned_long'
  }],
  locationsAvailable: [_types.Location.STATS, _types.Location.EVAL, _types.Location.WHERE, _types.Location.ROW, _types.Location.SORT, _types.Location.STATS_WHERE, _types.Location.STATS_BY, _types.Location.COMPLETION, _types.Location.RERANK, _types.Location.JOIN],
  examples: []
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const equalsDefinition = {
  type: _types2.FunctionDefinitionTypes.OPERATOR,
  name: '==',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.equals', {
    defaultMessage: 'Check if two fields are equal. If either field is multivalued then the result is `null`.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'left',
      type: 'boolean',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'boolean',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'cartesian_point',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'cartesian_point',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'cartesian_shape',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'cartesian_shape',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'date',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'date_nanos',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date_nanos',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'date',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date_nanos',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'date_nanos',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'double',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'integer',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'long',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'geo_point',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'geo_point',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'geo_shape',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'geo_shape',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'geohash',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'geohash',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'geohex',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'geohex',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'geotile',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'geotile',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'double',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'integer',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'long',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'ip',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'ip',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'keyword',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'keyword',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'keyword',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'text',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'double',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'integer',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'long',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'keyword',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'text',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'unsigned_long',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'unsigned_long',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'version',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'version',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'ip'
    }, {
      name: 'right',
      type: 'text',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      constantOnly: true
    }, {
      name: 'right',
      type: 'ip'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'version'
    }, {
      name: 'right',
      type: 'text',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      constantOnly: true
    }, {
      name: 'right',
      type: 'version'
    }],
    returnType: 'boolean'
  }],
  locationsAvailable: [_types.Location.STATS, _types.Location.EVAL, _types.Location.WHERE, _types.Location.ROW, _types.Location.SORT, _types.Location.STATS_WHERE, _types.Location.STATS_BY, _types.Location.COMPLETION, _types.Location.RERANK, _types.Location.JOIN],
  examples: []
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const greaterThanDefinition = {
  type: _types2.FunctionDefinitionTypes.OPERATOR,
  name: '>',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.greater_than', {
    defaultMessage: 'Check if one field is greater than another. If either field is multivalued then the result is `null`.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'left',
      type: 'date',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'date',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'date_nanos',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date_nanos',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'date',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date_nanos',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'date_nanos',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'double',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'integer',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'long',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'double',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'integer',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'long',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'ip',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'ip',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'keyword',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'keyword',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'keyword',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'text',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'double',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'integer',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'long',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'keyword',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'text',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'unsigned_long',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'unsigned_long',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'version',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'version',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'ip'
    }, {
      name: 'right',
      type: 'text',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      constantOnly: true
    }, {
      name: 'right',
      type: 'ip'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'version'
    }, {
      name: 'right',
      type: 'text',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      constantOnly: true
    }, {
      name: 'right',
      type: 'version'
    }],
    returnType: 'boolean'
  }],
  locationsAvailable: [_types.Location.STATS, _types.Location.EVAL, _types.Location.WHERE, _types.Location.ROW, _types.Location.SORT, _types.Location.STATS_WHERE, _types.Location.STATS_BY, _types.Location.COMPLETION, _types.Location.RERANK, _types.Location.JOIN],
  examples: []
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const greaterThanOrEqualDefinition = {
  type: _types2.FunctionDefinitionTypes.OPERATOR,
  name: '>=',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.greater_than_or_equal', {
    defaultMessage: 'Check if one field is greater than or equal to another. If either field is multivalued then the result is `null`.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'left',
      type: 'date',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'date',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'date_nanos',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date_nanos',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'date',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date_nanos',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'date_nanos',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'double',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'integer',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'long',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'double',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'integer',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'long',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'ip',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'ip',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'keyword',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'keyword',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'keyword',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'text',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'double',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'integer',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'long',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'keyword',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'text',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'unsigned_long',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'unsigned_long',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'version',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'version',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'ip'
    }, {
      name: 'right',
      type: 'text',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      constantOnly: true
    }, {
      name: 'right',
      type: 'ip'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'version'
    }, {
      name: 'right',
      type: 'text',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      constantOnly: true
    }, {
      name: 'right',
      type: 'version'
    }],
    returnType: 'boolean'
  }],
  locationsAvailable: [_types.Location.STATS, _types.Location.EVAL, _types.Location.WHERE, _types.Location.ROW, _types.Location.SORT, _types.Location.STATS_WHERE, _types.Location.STATS_BY, _types.Location.COMPLETION, _types.Location.RERANK, _types.Location.JOIN],
  examples: []
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const inDefinition = {
  type: _types2.FunctionDefinitionTypes.OPERATOR,
  name: 'in',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.in', {
    defaultMessage: 'The `IN` operator allows testing whether a field or expression equals an element in a list of literals, fields or expressions.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'left',
      type: 'boolean',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'boolean[]',
      optional: false,
      description: 'A list of items.'
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'cartesian_point',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'cartesian_point[]',
      optional: false,
      description: 'A list of items.'
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'cartesian_shape',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'cartesian_shape[]',
      optional: false,
      description: 'A list of items.'
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'double[]',
      optional: false,
      description: 'A list of items.'
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'geo_point',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'geo_point[]',
      optional: false,
      description: 'A list of items.'
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'geo_shape',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'geo_shape[]',
      optional: false,
      description: 'A list of items.'
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'integer[]',
      optional: false,
      description: 'A list of items.'
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'ip',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'ip[]',
      optional: false,
      description: 'A list of items.'
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'keyword',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'keyword[]',
      optional: false,
      description: 'A list of items.'
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'keyword',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'text[]',
      optional: false,
      description: 'A list of items.'
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'long[]',
      optional: false,
      description: 'A list of items.'
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'text',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'keyword[]',
      optional: false,
      description: 'A list of items.'
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'text',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'text[]',
      optional: false,
      description: 'A list of items.'
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'version',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'version[]',
      optional: false,
      description: 'A list of items.'
    }],
    returnType: 'boolean',
    minParams: 2
  }],
  locationsAvailable: [_types.Location.EVAL, _types.Location.WHERE, _types.Location.SORT, _types.Location.ROW, _types.Location.STATS_WHERE, _types.Location.COMPLETION, _types.Location.RERANK, _types.Location.JOIN],
  examples: ['ROW a = 1, b = 4, c = 3\n| WHERE c-a IN (3, b / 2, a)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const isNotNullDefinition = {
  type: _types2.FunctionDefinitionTypes.OPERATOR,
  name: 'is not null',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.is_not_null', {
    defaultMessage: 'Returns `false` if the value is `NULL`, `true` otherwise.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'left',
      type: 'aggregate_metric_double',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'boolean',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'cartesian_point',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'cartesian_shape',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'counter_double',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'counter_integer',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'counter_long',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date_nanos',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'dense_vector',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'exponential_histogram',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'geo_point',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'geo_shape',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'geohash',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'geohex',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'geotile',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'ip',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'keyword',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'unsigned_long',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'version',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }],
  locationsAvailable: [_types.Location.EVAL, _types.Location.WHERE, _types.Location.SORT, _types.Location.ROW, _types.Location.STATS_WHERE, _types.Location.COMPLETION, _types.Location.RERANK, _types.Location.JOIN],
  examples: ['FROM employees\n| WHERE is_rehired IS NOT NULL\n| STATS COUNT(emp_no)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const isNullDefinition = {
  type: _types2.FunctionDefinitionTypes.OPERATOR,
  name: 'is null',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.is_null', {
    defaultMessage: 'Returns `true` if the value is `NULL`, `false` otherwise.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'left',
      type: 'aggregate_metric_double',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'boolean',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'cartesian_point',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'cartesian_shape',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'counter_double',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'counter_integer',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'counter_long',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date_nanos',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'dense_vector',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'exponential_histogram',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'geo_point',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'geo_shape',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'geohash',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'geohex',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'geotile',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'ip',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'keyword',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'unsigned_long',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'version',
      optional: false,
      description: 'Value to check. It can be a single- or multi-valued column or an expression.'
    }],
    returnType: 'boolean'
  }],
  locationsAvailable: [_types.Location.EVAL, _types.Location.WHERE, _types.Location.SORT, _types.Location.ROW, _types.Location.STATS_WHERE, _types.Location.COMPLETION, _types.Location.RERANK, _types.Location.JOIN],
  examples: ['FROM employees\n| WHERE birth_date IS NULL']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const lessThanDefinition = {
  type: _types2.FunctionDefinitionTypes.OPERATOR,
  name: '<',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.less_than', {
    defaultMessage: 'Check if one field is less than another. If either field is multivalued then the result is `null`.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'left',
      type: 'date',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'date',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'date_nanos',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date_nanos',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'date',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date_nanos',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'date_nanos',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'double',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'integer',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'long',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'double',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'integer',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'long',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'ip',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'ip',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'keyword',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'keyword',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'keyword',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'text',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'double',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'integer',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'long',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'keyword',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'text',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'unsigned_long',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'unsigned_long',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'version',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'version',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'ip'
    }, {
      name: 'right',
      type: 'text',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      constantOnly: true
    }, {
      name: 'right',
      type: 'ip'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'version'
    }, {
      name: 'right',
      type: 'text',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      constantOnly: true
    }, {
      name: 'right',
      type: 'version'
    }],
    returnType: 'boolean'
  }],
  locationsAvailable: [_types.Location.STATS, _types.Location.EVAL, _types.Location.WHERE, _types.Location.ROW, _types.Location.SORT, _types.Location.STATS_WHERE, _types.Location.STATS_BY, _types.Location.COMPLETION, _types.Location.RERANK, _types.Location.JOIN],
  examples: []
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const lessThanOrEqualDefinition = {
  type: _types2.FunctionDefinitionTypes.OPERATOR,
  name: '<=',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.less_than_or_equal', {
    defaultMessage: 'Check if one field is less than or equal to another. If either field is multivalued then the result is `null`.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'left',
      type: 'date',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'date',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'date_nanos',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date_nanos',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'date',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date_nanos',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'date_nanos',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'double',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'integer',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'long',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'double',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'integer',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'long',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'ip',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'ip',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'keyword',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'keyword',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'keyword',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'text',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'double',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'integer',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'long',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'keyword',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'text',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'unsigned_long',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'unsigned_long',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'version',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'version',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'ip'
    }, {
      name: 'right',
      type: 'text',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      constantOnly: true
    }, {
      name: 'right',
      type: 'ip'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'version'
    }, {
      name: 'right',
      type: 'text',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      constantOnly: true
    }, {
      name: 'right',
      type: 'version'
    }],
    returnType: 'boolean'
  }],
  locationsAvailable: [_types.Location.STATS, _types.Location.EVAL, _types.Location.WHERE, _types.Location.ROW, _types.Location.SORT, _types.Location.STATS_WHERE, _types.Location.STATS_BY, _types.Location.COMPLETION, _types.Location.RERANK, _types.Location.JOIN],
  examples: []
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const likeDefinition = {
  type: _types2.FunctionDefinitionTypes.OPERATOR,
  name: 'like',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.like', {
    defaultMessage: 'Use `LIKE` to filter data based on string patterns using wildcards. `LIKE`\nusually acts on a field placed on the left-hand side of the operator, but it can\nalso act on a constant (literal) expression. The right-hand side of the operator\nrepresents the pattern.\n\nThe following wildcard characters are supported:\n\n* `*` matches zero or more characters.\n* `?` matches one character.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'str',
      type: 'keyword',
      optional: false,
      description: 'A literal expression.'
    }, {
      name: 'pattern',
      type: 'keyword',
      optional: false,
      description: 'Pattern.'
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'str',
      type: 'text',
      optional: false,
      description: 'A literal expression.'
    }, {
      name: 'pattern',
      type: 'keyword',
      optional: false,
      description: 'Pattern.'
    }],
    returnType: 'boolean',
    minParams: 2
  }],
  locationsAvailable: [_types.Location.EVAL, _types.Location.WHERE, _types.Location.SORT, _types.Location.ROW, _types.Location.STATS_WHERE, _types.Location.COMPLETION, _types.Location.RERANK, _types.Location.JOIN],
  examples: ['FROM employees\n| WHERE first_name LIKE """?b*"""\n| KEEP first_name, last_name']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const matchOperatorDefinition = {
  type: _types2.FunctionDefinitionTypes.OPERATOR,
  name: ':',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.match_operator', {
    defaultMessage: 'Use the match operator (`:`) to perform a match query on the specified field.\nUsing `:` is equivalent to using the `match` query in the Elasticsearch Query DSL.\n\nThe match operator is equivalent to the match function.\n\nFor using the function syntax, or adding match query parameters, you can use the\nmatch function.\n\n`:` returns true if the provided query matches the row.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'left',
      type: 'boolean',
      optional: false,
      description: 'Field that the query will target.',
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'boolean',
      optional: false,
      description: 'Value to find in the provided field.',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'boolean',
      optional: false,
      description: 'Field that the query will target.',
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'keyword',
      optional: false,
      description: 'Value to find in the provided field.',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date',
      optional: false,
      description: 'Field that the query will target.',
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'date',
      optional: false,
      description: 'Value to find in the provided field.',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date',
      optional: false,
      description: 'Field that the query will target.',
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'keyword',
      optional: false,
      description: 'Value to find in the provided field.',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date_nanos',
      optional: false,
      description: 'Field that the query will target.',
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'date_nanos',
      optional: false,
      description: 'Value to find in the provided field.',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date_nanos',
      optional: false,
      description: 'Field that the query will target.',
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'keyword',
      optional: false,
      description: 'Value to find in the provided field.',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false,
      description: 'Field that the query will target.',
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'double',
      optional: false,
      description: 'Value to find in the provided field.',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false,
      description: 'Field that the query will target.',
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'integer',
      optional: false,
      description: 'Value to find in the provided field.',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false,
      description: 'Field that the query will target.',
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'keyword',
      optional: false,
      description: 'Value to find in the provided field.',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false,
      description: 'Field that the query will target.',
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'long',
      optional: false,
      description: 'Value to find in the provided field.',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false,
      description: 'Field that the query will target.',
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'double',
      optional: false,
      description: 'Value to find in the provided field.',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false,
      description: 'Field that the query will target.',
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'integer',
      optional: false,
      description: 'Value to find in the provided field.',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false,
      description: 'Field that the query will target.',
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'keyword',
      optional: false,
      description: 'Value to find in the provided field.',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false,
      description: 'Field that the query will target.',
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'long',
      optional: false,
      description: 'Value to find in the provided field.',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'ip',
      optional: false,
      description: 'Field that the query will target.',
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'ip',
      optional: false,
      description: 'Value to find in the provided field.',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'ip',
      optional: false,
      description: 'Field that the query will target.',
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'keyword',
      optional: false,
      description: 'Value to find in the provided field.',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'keyword',
      optional: false,
      description: 'Field that the query will target.',
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'keyword',
      optional: false,
      description: 'Value to find in the provided field.',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false,
      description: 'Field that the query will target.',
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'double',
      optional: false,
      description: 'Value to find in the provided field.',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false,
      description: 'Field that the query will target.',
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'integer',
      optional: false,
      description: 'Value to find in the provided field.',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false,
      description: 'Field that the query will target.',
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'keyword',
      optional: false,
      description: 'Value to find in the provided field.',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false,
      description: 'Field that the query will target.',
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'long',
      optional: false,
      description: 'Value to find in the provided field.',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      optional: false,
      description: 'Field that the query will target.',
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'keyword',
      optional: false,
      description: 'Value to find in the provided field.',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'unsigned_long',
      optional: false,
      description: 'Field that the query will target.',
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'double',
      optional: false,
      description: 'Value to find in the provided field.',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'unsigned_long',
      optional: false,
      description: 'Field that the query will target.',
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'integer',
      optional: false,
      description: 'Value to find in the provided field.',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'unsigned_long',
      optional: false,
      description: 'Field that the query will target.',
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'keyword',
      optional: false,
      description: 'Value to find in the provided field.',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'unsigned_long',
      optional: false,
      description: 'Field that the query will target.',
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'long',
      optional: false,
      description: 'Value to find in the provided field.',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'unsigned_long',
      optional: false,
      description: 'Field that the query will target.',
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'unsigned_long',
      optional: false,
      description: 'Value to find in the provided field.',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'version',
      optional: false,
      description: 'Field that the query will target.',
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'keyword',
      optional: false,
      description: 'Value to find in the provided field.',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'version',
      optional: false,
      description: 'Field that the query will target.',
      fieldsOnly: true
    }, {
      name: 'query',
      type: 'version',
      optional: false,
      description: 'Value to find in the provided field.',
      constantOnly: true
    }],
    returnType: 'boolean'
  }],
  locationsAvailable: [_types.Location.WHERE, _types.Location.STATS_WHERE, _types.Location.JOIN, _types.Location.EVAL],
  examples: ['FROM books\n| WHERE author:"Faulkner"']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const modDefinition = {
  type: _types2.FunctionDefinitionTypes.OPERATOR,
  name: '%',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.mod', {
    defaultMessage: 'Divide one number by another and return the remainder. If either field is multivalued then the result is `null`.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'left',
      type: 'double',
      optional: false,
      description: 'A numeric value.'
    }, {
      name: 'right',
      type: 'double',
      optional: false,
      description: 'A numeric value.'
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false,
      description: 'A numeric value.'
    }, {
      name: 'right',
      type: 'integer',
      optional: false,
      description: 'A numeric value.'
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false,
      description: 'A numeric value.'
    }, {
      name: 'right',
      type: 'long',
      optional: false,
      description: 'A numeric value.'
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false,
      description: 'A numeric value.'
    }, {
      name: 'right',
      type: 'double',
      optional: false,
      description: 'A numeric value.'
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false,
      description: 'A numeric value.'
    }, {
      name: 'right',
      type: 'integer',
      optional: false,
      description: 'A numeric value.'
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false,
      description: 'A numeric value.'
    }, {
      name: 'right',
      type: 'long',
      optional: false,
      description: 'A numeric value.'
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false,
      description: 'A numeric value.'
    }, {
      name: 'right',
      type: 'double',
      optional: false,
      description: 'A numeric value.'
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false,
      description: 'A numeric value.'
    }, {
      name: 'right',
      type: 'integer',
      optional: false,
      description: 'A numeric value.'
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false,
      description: 'A numeric value.'
    }, {
      name: 'right',
      type: 'long',
      optional: false,
      description: 'A numeric value.'
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'left',
      type: 'unsigned_long',
      optional: false,
      description: 'A numeric value.'
    }, {
      name: 'right',
      type: 'unsigned_long',
      optional: false,
      description: 'A numeric value.'
    }],
    returnType: 'unsigned_long'
  }],
  locationsAvailable: [_types.Location.STATS, _types.Location.EVAL, _types.Location.WHERE, _types.Location.ROW, _types.Location.SORT, _types.Location.STATS_WHERE, _types.Location.STATS_BY, _types.Location.COMPLETION, _types.Location.RERANK, _types.Location.JOIN],
  examples: []
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const mulDefinition = {
  type: _types2.FunctionDefinitionTypes.OPERATOR,
  name: '*',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.mul', {
    defaultMessage: 'Multiply two numbers together. If either field is multivalued then the result is `null`.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'left',
      type: 'double',
      optional: false,
      description: 'A numeric value.'
    }, {
      name: 'right',
      type: 'double',
      optional: false,
      description: 'A numeric value.'
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false,
      description: 'A numeric value.'
    }, {
      name: 'right',
      type: 'integer',
      optional: false,
      description: 'A numeric value.'
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false,
      description: 'A numeric value.'
    }, {
      name: 'right',
      type: 'long',
      optional: false,
      description: 'A numeric value.'
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false,
      description: 'A numeric value.'
    }, {
      name: 'right',
      type: 'double',
      optional: false,
      description: 'A numeric value.'
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false,
      description: 'A numeric value.'
    }, {
      name: 'right',
      type: 'integer',
      optional: false,
      description: 'A numeric value.'
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false,
      description: 'A numeric value.'
    }, {
      name: 'right',
      type: 'long',
      optional: false,
      description: 'A numeric value.'
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false,
      description: 'A numeric value.'
    }, {
      name: 'right',
      type: 'double',
      optional: false,
      description: 'A numeric value.'
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false,
      description: 'A numeric value.'
    }, {
      name: 'right',
      type: 'integer',
      optional: false,
      description: 'A numeric value.'
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false,
      description: 'A numeric value.'
    }, {
      name: 'right',
      type: 'long',
      optional: false,
      description: 'A numeric value.'
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'left',
      type: 'unsigned_long',
      optional: false,
      description: 'A numeric value.'
    }, {
      name: 'right',
      type: 'unsigned_long',
      optional: false,
      description: 'A numeric value.'
    }],
    returnType: 'unsigned_long'
  }],
  locationsAvailable: [_types.Location.STATS, _types.Location.EVAL, _types.Location.WHERE, _types.Location.ROW, _types.Location.SORT, _types.Location.STATS_WHERE, _types.Location.STATS_BY, _types.Location.COMPLETION, _types.Location.RERANK, _types.Location.JOIN],
  examples: []
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const negDefinition = {
  type: _types2.FunctionDefinitionTypes.OPERATOR,
  name: '-',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.neg', {
    defaultMessage: 'Returns the negation of the argument.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'left',
      type: 'date_period',
      optional: false,
      description: 'A numeric value or a date time interval.'
    }],
    returnType: 'date_period'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false,
      description: 'A numeric value or a date time interval.'
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false,
      description: 'A numeric value or a date time interval.'
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false,
      description: 'A numeric value or a date time interval.'
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'left',
      type: 'time_duration',
      optional: false,
      description: 'A numeric value or a date time interval.'
    }],
    returnType: 'time_duration'
  }],
  locationsAvailable: [_types.Location.STATS],
  examples: []
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const notInDefinition = {
  type: _types2.FunctionDefinitionTypes.OPERATOR,
  name: 'not in',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.not_in', {
    defaultMessage: 'The `NOT IN` operator allows testing whether a field or expression does *not* equal any element in a list of literals, fields or expressions.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'left',
      type: 'boolean',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'boolean[]',
      optional: false,
      description: 'A list of items.'
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'cartesian_point',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'cartesian_point[]',
      optional: false,
      description: 'A list of items.'
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'cartesian_shape',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'cartesian_shape[]',
      optional: false,
      description: 'A list of items.'
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'double[]',
      optional: false,
      description: 'A list of items.'
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'geo_point',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'geo_point[]',
      optional: false,
      description: 'A list of items.'
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'geo_shape',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'geo_shape[]',
      optional: false,
      description: 'A list of items.'
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'integer[]',
      optional: false,
      description: 'A list of items.'
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'ip',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'ip[]',
      optional: false,
      description: 'A list of items.'
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'keyword',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'keyword[]',
      optional: false,
      description: 'A list of items.'
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'keyword',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'text[]',
      optional: false,
      description: 'A list of items.'
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'long[]',
      optional: false,
      description: 'A list of items.'
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'text',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'keyword[]',
      optional: false,
      description: 'A list of items.'
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'text',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'text[]',
      optional: false,
      description: 'A list of items.'
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'left',
      type: 'version',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'version[]',
      optional: false,
      description: 'A list of items.'
    }],
    returnType: 'boolean',
    minParams: 2
  }],
  locationsAvailable: [_types.Location.EVAL, _types.Location.WHERE, _types.Location.SORT, _types.Location.ROW, _types.Location.STATS_WHERE, _types.Location.COMPLETION, _types.Location.RERANK, _types.Location.JOIN],
  examples: []
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const notLikeDefinition = {
  type: _types2.FunctionDefinitionTypes.OPERATOR,
  name: 'not like',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.not_like', {
    defaultMessage: 'Use `LIKE` to filter data based on string patterns using wildcards. `LIKE`\nusually acts on a field placed on the left-hand side of the operator, but it can\nalso act on a constant (literal) expression. The right-hand side of the operator\nrepresents the pattern.\n\nThe following wildcard characters are supported:\n\n* `*` matches zero or more characters.\n* `?` matches one character.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'str',
      type: 'keyword',
      optional: false,
      description: 'A literal expression.'
    }, {
      name: 'pattern',
      type: 'keyword',
      optional: false,
      description: 'Pattern.'
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'str',
      type: 'text',
      optional: false,
      description: 'A literal expression.'
    }, {
      name: 'pattern',
      type: 'keyword',
      optional: false,
      description: 'Pattern.'
    }],
    returnType: 'boolean',
    minParams: 2
  }],
  locationsAvailable: [_types.Location.EVAL, _types.Location.WHERE, _types.Location.SORT, _types.Location.ROW, _types.Location.STATS_WHERE, _types.Location.COMPLETION, _types.Location.RERANK, _types.Location.JOIN],
  examples: []
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const notRlikeDefinition = {
  type: _types2.FunctionDefinitionTypes.OPERATOR,
  name: 'not rlike',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.not_rlike', {
    defaultMessage: 'Use `RLIKE` to filter data based on string patterns using\nregular expressions. `RLIKE` usually acts on a field placed on\nthe left-hand side of the operator, but it can also act on a constant (literal)\nexpression. The right-hand side of the operator represents the pattern.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'str',
      type: 'keyword',
      optional: false,
      description: 'A literal value.'
    }, {
      name: 'pattern',
      type: 'keyword',
      optional: false,
      description: 'A regular expression.'
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'str',
      type: 'text',
      optional: false,
      description: 'A literal value.'
    }, {
      name: 'pattern',
      type: 'keyword',
      optional: false,
      description: 'A regular expression.'
    }],
    returnType: 'boolean',
    minParams: 2
  }],
  locationsAvailable: [_types.Location.EVAL, _types.Location.WHERE, _types.Location.SORT, _types.Location.ROW, _types.Location.STATS_WHERE, _types.Location.COMPLETION, _types.Location.RERANK, _types.Location.JOIN],
  examples: []
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const notEqualsDefinition = {
  type: _types2.FunctionDefinitionTypes.OPERATOR,
  name: '!=',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.not_equals', {
    defaultMessage: 'Check if two fields are unequal. If either field is multivalued then the result is `null`.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'left',
      type: 'boolean',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'boolean',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'cartesian_point',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'cartesian_point',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'cartesian_shape',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'cartesian_shape',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'date',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'date_nanos',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date_nanos',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'date',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date_nanos',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'date_nanos',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'double',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'integer',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'long',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'geo_point',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'geo_point',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'geo_shape',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'geo_shape',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'geohash',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'geohash',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'geohex',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'geohex',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'geotile',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'geotile',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'double',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'integer',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'long',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'ip',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'ip',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'keyword',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'keyword',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'keyword',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'text',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'double',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'integer',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'long',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'keyword',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'text',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'unsigned_long',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'unsigned_long',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'version',
      optional: false,
      description: 'An expression.'
    }, {
      name: 'right',
      type: 'version',
      optional: false,
      description: 'An expression.'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'ip'
    }, {
      name: 'right',
      type: 'text',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      constantOnly: true
    }, {
      name: 'right',
      type: 'ip'
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'version'
    }, {
      name: 'right',
      type: 'text',
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      constantOnly: true
    }, {
      name: 'right',
      type: 'version'
    }],
    returnType: 'boolean'
  }],
  locationsAvailable: [_types.Location.STATS, _types.Location.EVAL, _types.Location.WHERE, _types.Location.ROW, _types.Location.SORT, _types.Location.STATS_WHERE, _types.Location.STATS_BY, _types.Location.COMPLETION, _types.Location.RERANK, _types.Location.JOIN],
  examples: []
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const rlikeDefinition = {
  type: _types2.FunctionDefinitionTypes.OPERATOR,
  name: 'rlike',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.rlike', {
    defaultMessage: 'Use `RLIKE` to filter data based on string patterns using\nregular expressions. `RLIKE` usually acts on a field placed on\nthe left-hand side of the operator, but it can also act on a constant (literal)\nexpression. The right-hand side of the operator represents the pattern.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'str',
      type: 'keyword',
      optional: false,
      description: 'A literal value.'
    }, {
      name: 'pattern',
      type: 'keyword',
      optional: false,
      description: 'A regular expression.'
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'str',
      type: 'text',
      optional: false,
      description: 'A literal value.'
    }, {
      name: 'pattern',
      type: 'keyword',
      optional: false,
      description: 'A regular expression.'
    }],
    returnType: 'boolean',
    minParams: 2
  }],
  locationsAvailable: [_types.Location.EVAL, _types.Location.WHERE, _types.Location.SORT, _types.Location.ROW, _types.Location.STATS_WHERE, _types.Location.COMPLETION, _types.Location.RERANK, _types.Location.JOIN],
  examples: ['FROM employees\n| WHERE first_name RLIKE """.leja.*"""\n| KEEP first_name, last_name']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const subDefinition = {
  type: _types2.FunctionDefinitionTypes.OPERATOR,
  name: '-',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.sub', {
    defaultMessage: 'Subtract one number from another. If either field is multivalued then the result is `null`.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'left',
      type: 'date',
      optional: false,
      description: 'A numeric value or a date time value.'
    }, {
      name: 'right',
      type: 'date_period',
      optional: false,
      description: 'A numeric value or a date time value.'
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'left',
      type: 'date',
      optional: false,
      description: 'A numeric value or a date time value.'
    }, {
      name: 'right',
      type: 'time_duration',
      optional: false,
      description: 'A numeric value or a date time value.'
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'left',
      type: 'date_nanos',
      optional: false,
      description: 'A numeric value or a date time value.'
    }, {
      name: 'right',
      type: 'date_period',
      optional: false,
      description: 'A numeric value or a date time value.'
    }],
    returnType: 'date_nanos'
  }, {
    params: [{
      name: 'left',
      type: 'date_nanos',
      optional: false,
      description: 'A numeric value or a date time value.'
    }, {
      name: 'right',
      type: 'time_duration',
      optional: false,
      description: 'A numeric value or a date time value.'
    }],
    returnType: 'date_nanos'
  }, {
    params: [{
      name: 'left',
      type: 'date_period',
      optional: false,
      description: 'A numeric value or a date time value.'
    }, {
      name: 'right',
      type: 'date_nanos',
      optional: false,
      description: 'A numeric value or a date time value.'
    }],
    returnType: 'date_nanos'
  }, {
    params: [{
      name: 'left',
      type: 'date_period',
      optional: false,
      description: 'A numeric value or a date time value.'
    }, {
      name: 'right',
      type: 'date_period',
      optional: false,
      description: 'A numeric value or a date time value.'
    }],
    returnType: 'date_period'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false,
      description: 'A numeric value or a date time value.'
    }, {
      name: 'right',
      type: 'double',
      optional: false,
      description: 'A numeric value or a date time value.'
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false,
      description: 'A numeric value or a date time value.'
    }, {
      name: 'right',
      type: 'integer',
      optional: false,
      description: 'A numeric value or a date time value.'
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false,
      description: 'A numeric value or a date time value.'
    }, {
      name: 'right',
      type: 'long',
      optional: false,
      description: 'A numeric value or a date time value.'
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false,
      description: 'A numeric value or a date time value.'
    }, {
      name: 'right',
      type: 'double',
      optional: false,
      description: 'A numeric value or a date time value.'
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false,
      description: 'A numeric value or a date time value.'
    }, {
      name: 'right',
      type: 'integer',
      optional: false,
      description: 'A numeric value or a date time value.'
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false,
      description: 'A numeric value or a date time value.'
    }, {
      name: 'right',
      type: 'long',
      optional: false,
      description: 'A numeric value or a date time value.'
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false,
      description: 'A numeric value or a date time value.'
    }, {
      name: 'right',
      type: 'double',
      optional: false,
      description: 'A numeric value or a date time value.'
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false,
      description: 'A numeric value or a date time value.'
    }, {
      name: 'right',
      type: 'integer',
      optional: false,
      description: 'A numeric value or a date time value.'
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false,
      description: 'A numeric value or a date time value.'
    }, {
      name: 'right',
      type: 'long',
      optional: false,
      description: 'A numeric value or a date time value.'
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'left',
      type: 'time_duration',
      optional: false,
      description: 'A numeric value or a date time value.'
    }, {
      name: 'right',
      type: 'date_nanos',
      optional: false,
      description: 'A numeric value or a date time value.'
    }],
    returnType: 'date_nanos'
  }, {
    params: [{
      name: 'left',
      type: 'time_duration',
      optional: false,
      description: 'A numeric value or a date time value.'
    }, {
      name: 'right',
      type: 'time_duration',
      optional: false,
      description: 'A numeric value or a date time value.'
    }],
    returnType: 'time_duration'
  }, {
    params: [{
      name: 'left',
      type: 'unsigned_long',
      optional: false,
      description: 'A numeric value or a date time value.'
    }, {
      name: 'right',
      type: 'unsigned_long',
      optional: false,
      description: 'A numeric value or a date time value.'
    }],
    returnType: 'unsigned_long'
  }, {
    params: [{
      name: 'left',
      type: 'time_duration'
    }, {
      name: 'right',
      type: 'date'
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'left',
      type: 'date'
    }, {
      name: 'right',
      type: 'time_duration'
    }],
    returnType: 'date'
  }],
  locationsAvailable: [_types.Location.STATS, _types.Location.EVAL, _types.Location.WHERE, _types.Location.ROW, _types.Location.SORT, _types.Location.STATS_WHERE, _types.Location.STATS_BY, _types.Location.COMPLETION, _types.Location.RERANK, _types.Location.JOIN],
  examples: []
};
const operatorFunctionDefinitions = exports.operatorFunctionDefinitions = [addDefinition, divDefinition, equalsDefinition, greaterThanDefinition, greaterThanOrEqualDefinition, inDefinition, isNotNullDefinition, isNullDefinition, lessThanDefinition, lessThanOrEqualDefinition, likeDefinition, matchOperatorDefinition, modDefinition, mulDefinition, negDefinition, notInDefinition, notLikeDefinition, notRlikeDefinition, notEqualsDefinition, rlikeDefinition, subDefinition];