"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.omitUnsetKeys = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const isSet = (def, key) => Object.keys(def !== null && def !== void 0 ? def : {}).includes(key);
const omitUnsetKeys = (defaults, def) => {
  return (0, _lodash.extend)({}, defaults, def, (objValue, _, key) => {
    if (isSet(def, key) && objValue === undefined) {
      return undefined;
    }
    return objValue;
  });
};
exports.omitUnsetKeys = omitUnsetKeys;