"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateHistoryIndexTemplateId = generateHistoryIndexTemplateId;
exports.generateHistoryTransformId = exports.generateHistoryIngestPipelineId = void 0;
exports.generateLatestIndexName = generateLatestIndexName;
exports.generateLatestTransformId = exports.generateLatestIngestPipelineId = exports.generateLatestIndexTemplateId = void 0;
exports.generateResetIndexTemplateId = generateResetIndexTemplateId;
exports.generateUpdatesIndexTemplateId = void 0;
var _entitiesSchema = require("@kbn/entities-schema");
var _constants_entities = require("../../../../common/constants_entities");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// History
function generateHistoryId(definition) {
  return `${_constants_entities.ENTITY_HISTORY_PREFIX_V1}-${definition.id}`;
}

// History
const generateHistoryTransformId = exports.generateHistoryTransformId = generateHistoryId;
const generateHistoryIngestPipelineId = exports.generateHistoryIngestPipelineId = generateHistoryId;
function generateHistoryIndexTemplateId(definition) {
  return `${_entitiesSchema.ENTITY_BASE_PREFIX}_${_entitiesSchema.ENTITY_SCHEMA_VERSION_V1}_${_entitiesSchema.ENTITY_HISTORY}_${definition.id}_index_template`;
}

// Latest
function generateLatestId(definition) {
  return `${_constants_entities.ENTITY_LATEST_PREFIX_V1}-${definition.id}`;
}
const generateLatestTransformId = exports.generateLatestTransformId = generateLatestId;
const generateLatestIngestPipelineId = exports.generateLatestIngestPipelineId = generateLatestId;
function generateLatestIndexName(definition) {
  return (0, _entitiesSchema.entitiesIndexPattern)({
    schemaVersion: _entitiesSchema.ENTITY_SCHEMA_VERSION_V1,
    dataset: _entitiesSchema.ENTITY_LATEST,
    definitionId: definition.id
  });
}
const generateLatestIndexTemplateId = definition => `${_entitiesSchema.ENTITY_BASE_PREFIX}_${_entitiesSchema.ENTITY_SCHEMA_VERSION_V1}_${_entitiesSchema.ENTITY_LATEST}_${definition.id}_index_template`;

// Reset
exports.generateLatestIndexTemplateId = generateLatestIndexTemplateId;
function generateResetIndexTemplateId(definition) {
  return `${_entitiesSchema.ENTITY_BASE_PREFIX}_${_entitiesSchema.ENTITY_SCHEMA_VERSION_V1}_${_entitiesSchema.ENTITY_RESET}_${definition.id}_index_template`;
}
const generateUpdatesIndexTemplateId = definition => `${_entitiesSchema.ENTITY_BASE_PREFIX}_${_entitiesSchema.ENTITY_SCHEMA_VERSION_V1}_${_entitiesSchema.ENTITY_UPDATES}_${definition.id}_index_template`;
exports.generateUpdatesIndexTemplateId = generateUpdatesIndexTemplateId;