"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addConnector = void 0;
var _searchConnectors = require("@kbn/search-connectors");
var _constants = require("../../../common/constants");
var _error_codes = require("../../../common/types/error_codes");
var _create_index = require("../indices/create_index");
var _generate_api_key = require("../indices/generate_api_key");
var _get_default_pipeline = require("../pipelines/get_default_pipeline");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const addConnector = async (client, input) => {
  const index = input.indexName;
  if (index) {
    const indexExists = await client.asCurrentUser.indices.exists({
      index
    });
    if (indexExists) {
      {
        throw new Error(_error_codes.ErrorCode.INDEX_ALREADY_EXISTS);
      }
    }
    const connector = await (0, _searchConnectors.fetchConnectorByIndexName)(client.asCurrentUser, index);
    if (connector) {
      if (input.deleteExistingConnector) {
        await (0, _searchConnectors.deleteConnectorById)(client.asCurrentUser, connector.id);
      } else {
        throw new Error(_error_codes.ErrorCode.CONNECTOR_DOCUMENT_ALREADY_EXISTS);
      }
    }
    await (0, _create_index.createIndex)(client, index, input.language, false);
  }
  const nativeConnector = input.isNative && input.serviceType ? _searchConnectors.NATIVE_CONNECTOR_DEFINITIONS[input.serviceType] : undefined;
  if (input.isNative && input.serviceType && !nativeConnector && input.serviceType !== _constants.ENTERPRISE_SEARCH_CONNECTOR_CRAWLER_SERVICE_TYPE) {
    throw new Error(`Could not find connector definition for service type ${input.serviceType}`);
  }
  const nativeFields = nativeConnector ? {
    configuration: nativeConnector.configuration,
    features: nativeConnector.features,
    status: _searchConnectors.ConnectorStatus.NEEDS_CONFIGURATION
  } : {};
  const connector = await (0, _searchConnectors.createConnector)(client.asCurrentUser, {
    ...input,
    name: input.name || '',
    ...nativeFields,
    pipeline: await (0, _get_default_pipeline.getDefaultPipeline)(client)
  });

  // Only create API key for native connectors and if index name was provided
  if (index && input.isNative && input.serviceType !== _constants.ENTERPRISE_SEARCH_CONNECTOR_CRAWLER_SERVICE_TYPE) {
    await (0, _generate_api_key.generateApiKey)(client, index, true);
  }
  return connector;
};
exports.addConnector = addConnector;