"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.indexToOption = exports.IndicesSelectComboBox = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _api = require("../../../../../../common/types/api");
var _health_colors = require("../../../../shared/constants/health_colors");
var _fetch_indices_api_logic = require("../../../api/search_applications/fetch_indices_api_logic");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/applications/components/search_applications/components/indices_select_combobox.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const IndicesSelectComboBox = ({
  setIndicesSelectComboBoxDisabled,
  ignoredOptions,
  ...props
}) => {
  var _props$selectedOption, _ref, _data$indices, _data$indices$filter, _data$indices2;
  const [searchQuery, setSearchQuery] = (0, _react.useState)(undefined);
  const {
    makeRequest
  } = (0, _kea.useActions)(_fetch_indices_api_logic.FetchIndicesForSearchApplicationsAPILogic);
  const {
    status,
    data
  } = (0, _kea.useValues)(_fetch_indices_api_logic.FetchIndicesForSearchApplicationsAPILogic);
  const isInvalid = Boolean(searchQuery && !((_props$selectedOption = props.selectedOptions) !== null && _props$selectedOption !== void 0 && _props$selectedOption.length));
  (0, _react.useEffect)(() => {
    if (!setIndicesSelectComboBoxDisabled) return;
    setIndicesSelectComboBoxDisabled(isInvalid);
  }, [isInvalid]);
  (0, _react.useEffect)(() => {
    makeRequest({
      searchQuery
    });
  }, [searchQuery]);
  const options = (_ref = ignoredOptions && ignoredOptions.length > 0 ? data === null || data === void 0 ? void 0 : (_data$indices = data.indices) === null || _data$indices === void 0 ? void 0 : (_data$indices$filter = _data$indices.filter(index => !ignoredOptions.includes(index.name))) === null || _data$indices$filter === void 0 ? void 0 : _data$indices$filter.map(index => indexToOption(index.name, index)) : data === null || data === void 0 ? void 0 : (_data$indices2 = data.indices) === null || _data$indices2 === void 0 ? void 0 : _data$indices2.map(index => indexToOption(index.name, index))) !== null && _ref !== void 0 ? _ref : [];
  const renderOption = option => {
    var _option$value, _option$value$name, _option$value2, _option$value$count, _option$value3;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 5
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: (0, _health_colors.indexHealthToHealthColor)((_option$value = option.value) === null || _option$value === void 0 ? void 0 : _option$value.health),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
      search: searchQuery !== null && searchQuery !== void 0 ? searchQuery : '',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 11
      }
    }, (_option$value$name = (_option$value2 = option.value) === null || _option$value2 === void 0 ? void 0 : _option$value2.name) !== null && _option$value$name !== void 0 ? _option$value$name : ''))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.indicesSelect.docsLabel', {
      defaultMessage: 'Docs:'
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedNumber, {
      value: (_option$value$count = (_option$value3 = option.value) === null || _option$value3 === void 0 ? void 0 : _option$value3.count) !== null && _option$value$count !== void 0 ? _option$value$count : 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 9
      }
    })));
  };
  const defaultedProps = {
    isLoading: status === _api.Status.LOADING,
    onSearchChange: searchValue => {
      setSearchQuery(searchValue);
    },
    options,
    renderOption,
    ...props
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: props.label || null,
    fullWidth: props.fullWidth,
    isInvalid: isInvalid,
    error: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.indicesSelectComboBox.error', {
      defaultMessage: 'No indices match the entered value'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({
    async: true,
    isInvalid: isInvalid
  }, defaultedProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 7
    }
  })));
};
exports.IndicesSelectComboBox = IndicesSelectComboBox;
const indexToOption = (indexName, index) => ({
  label: indexName,
  value: index
});
exports.indexToOption = indexToOption;