"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.USER_RESOURCE = exports.SECURITY_LABS_RESOURCE = exports.SECURITY_LABS_LOADED_QUERY = exports.DEFEND_INSIGHTS_RESOURCES = exports.DEFEND_INSIGHTS_RESOURCE = exports.DEFEND_INSIGHTS_POLICY_RESPONSE_FAILURE = exports.DEFEND_INSIGHTS_LOADED_QUERY = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SECURITY_LABS_RESOURCE = exports.SECURITY_LABS_RESOURCE = 'security_labs';
const USER_RESOURCE = exports.USER_RESOURCE = 'user';
// Query for determining if Security Labs docs have been loaded. Intended for use with Telemetry
const SECURITY_LABS_LOADED_QUERY = exports.SECURITY_LABS_LOADED_QUERY = 'What is Elastic Security Labs';
const DEFEND_INSIGHTS_RESOURCE = exports.DEFEND_INSIGHTS_RESOURCE = 'defend_insights';
const DEFEND_INSIGHTS_RESOURCES = exports.DEFEND_INSIGHTS_RESOURCES = `${DEFEND_INSIGHTS_RESOURCE}:`;
const DEFEND_INSIGHTS_POLICY_RESPONSE_FAILURE = exports.DEFEND_INSIGHTS_POLICY_RESPONSE_FAILURE = `${DEFEND_INSIGHTS_RESOURCE}:policy_response_failure`;
// Query for determining if Defend Insights docs have been loaded
const DEFEND_INSIGHTS_LOADED_QUERY = exports.DEFEND_INSIGHTS_LOADED_QUERY = 'What are defend insights knowledge base entries';