"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAssistantAvailability = void 0;
var _constants = require("@kbn/security-solution-features/constants");
var _public = require("@kbn/onechat-plugin/public");
var _constants2 = require("../../../../common/constants");
var _typed_kibana_context = require("../../context/typed_kibana_context/typed_kibana_context");
var _use_licence = require("../licence/use_licence");
var _use_is_nav_control_visible = require("../is_nav_control_visible/use_is_nav_control_visible");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAssistantAvailability = () => {
  var _capabilities$ASSISTA, _capabilities$ASSISTA2, _capabilities$ASSISTA3, _capabilities$SECURIT, _capabilities$ONECHAT, _capabilities$ONECHAT2, _capabilities$advance, _capabilities$actions, _capabilities$actions2, _capabilities$actions3, _capabilities$actions4;
  const {
    isVisible
  } = (0, _use_is_nav_control_visible.useIsNavControlVisible)();
  const isEnterprise = (0, _use_licence.useLicense)().isEnterprise();
  const {
    application: {
      capabilities
    }
  } = (0, _typed_kibana_context.useKibana)().services;
  const hasAssistantPrivilege = ((_capabilities$ASSISTA = capabilities[_constants.ASSISTANT_FEATURE_ID]) === null || _capabilities$ASSISTA === void 0 ? void 0 : _capabilities$ASSISTA['ai-assistant']) === true;
  const hasUpdateAIAssistantAnonymization = ((_capabilities$ASSISTA2 = capabilities[_constants.ASSISTANT_FEATURE_ID]) === null || _capabilities$ASSISTA2 === void 0 ? void 0 : _capabilities$ASSISTA2.updateAIAssistantAnonymization) === true;
  const hasManageGlobalKnowledgeBase = ((_capabilities$ASSISTA3 = capabilities[_constants.ASSISTANT_FEATURE_ID]) === null || _capabilities$ASSISTA3 === void 0 ? void 0 : _capabilities$ASSISTA3.manageGlobalKnowledgeBaseAIAssistant) === true;
  const hasSearchAILakeConfigurations = ((_capabilities$SECURIT = capabilities[_constants2.SECURITY_FEATURE_ID]) === null || _capabilities$SECURIT === void 0 ? void 0 : _capabilities$SECURIT.configurations) === true;
  const hasAgentBuilderPrivilege = ((_capabilities$ONECHAT = capabilities[_public.ONECHAT_FEATURE_ID]) === null || _capabilities$ONECHAT === void 0 ? void 0 : _capabilities$ONECHAT.show) === true;
  const hasAgentBuilderManagePrivilege = ((_capabilities$ONECHAT2 = capabilities[_public.ONECHAT_FEATURE_ID]) === null || _capabilities$ONECHAT2 === void 0 ? void 0 : _capabilities$ONECHAT2.showManagement) === true && ((_capabilities$advance = capabilities.advancedSettings) === null || _capabilities$advance === void 0 ? void 0 : _capabilities$advance.save) === true;

  // Connectors & Actions capabilities as defined in x-pack/plugins/actions/server/feature.ts
  // `READ` ui capabilities defined as: { ui: ['show', 'execute'] }
  const hasConnectorsReadPrivilege = ((_capabilities$actions = capabilities.actions) === null || _capabilities$actions === void 0 ? void 0 : _capabilities$actions.show) === true && ((_capabilities$actions2 = capabilities.actions) === null || _capabilities$actions2 === void 0 ? void 0 : _capabilities$actions2.execute) === true;
  // `ALL` ui capabilities defined as: { ui: ['show', 'execute', 'save', 'delete'] }
  const hasConnectorsAllPrivilege = hasConnectorsReadPrivilege && ((_capabilities$actions3 = capabilities.actions) === null || _capabilities$actions3 === void 0 ? void 0 : _capabilities$actions3.delete) === true && ((_capabilities$actions4 = capabilities.actions) === null || _capabilities$actions4 === void 0 ? void 0 : _capabilities$actions4.save) === true;
  return {
    hasSearchAILakeConfigurations,
    hasAssistantPrivilege,
    hasConnectorsAllPrivilege,
    hasConnectorsReadPrivilege,
    isAssistantEnabled: isEnterprise,
    isAssistantVisible: isEnterprise && isVisible,
    isAssistantManagementEnabled: isEnterprise && hasAssistantPrivilege,
    hasUpdateAIAssistantAnonymization,
    hasManageGlobalKnowledgeBase,
    hasAgentBuilderPrivilege,
    hasAgentBuilderManagePrivilege
  };
};
exports.useAssistantAvailability = useAssistantAvailability;