"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.POST_INDEX_RESULTS = exports.PLUGIN_NAME = exports.PLUGIN_ID = exports.INTERNAL_API_VERSION = exports.GET_UNALLOWED_FIELD_VALUES = exports.GET_INDEX_STATS = exports.GET_INDEX_RESULTS_LATEST = exports.GET_INDEX_RESULTS = exports.GET_INDEX_MAPPINGS = exports.GET_ILM_EXPLAIN = exports.BASE_PATH = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PLUGIN_ID = exports.PLUGIN_ID = 'ecsDataQualityDashboard';
const PLUGIN_NAME = exports.PLUGIN_NAME = 'ecsDataQualityDashboard';
const BASE_PATH = exports.BASE_PATH = '/internal/ecs_data_quality_dashboard';
const GET_INDEX_STATS = exports.GET_INDEX_STATS = `${BASE_PATH}/stats/{pattern}`;
const GET_INDEX_MAPPINGS = exports.GET_INDEX_MAPPINGS = `${BASE_PATH}/mappings/{pattern}`;
const GET_UNALLOWED_FIELD_VALUES = exports.GET_UNALLOWED_FIELD_VALUES = `${BASE_PATH}/unallowed_field_values`;
const GET_ILM_EXPLAIN = exports.GET_ILM_EXPLAIN = `${BASE_PATH}/ilm_explain/{pattern}`;
const POST_INDEX_RESULTS = exports.POST_INDEX_RESULTS = `${BASE_PATH}/results`;
const GET_INDEX_RESULTS = exports.GET_INDEX_RESULTS = `${BASE_PATH}/results/{pattern}`;
const GET_INDEX_RESULTS_LATEST = exports.GET_INDEX_RESULTS_LATEST = `${BASE_PATH}/results_latest/{pattern}`;
const INTERNAL_API_VERSION = exports.INTERNAL_API_VERSION = '1';