"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReviewDissectFieldsPrompt = void 0;
var _zod = require("@kbn/zod");
var _inferenceCommon = require("@kbn/inference-common");
var _review_fields_prompt_template = _interopRequireDefault(require("./review_fields_prompt_template.text"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ReviewDissectFieldsPrompt = exports.ReviewDissectFieldsPrompt = (0, _inferenceCommon.createPrompt)({
  name: 'review_dissect_fields_prompt',
  description: 'Review and map dissect-extracted fields to ECS-compliant fields',
  input: _zod.z.object({
    /**
     * Raw log messages to pass to LLM
     */
    sample_messages: _zod.z.array(_zod.z.string()),
    /**
     * Fields to review (as JSON string)
     *
     * ```json
     * {
     *     "field_1": {
     *         "example_values": ["192.168.1.1", "10.0.0.1", "172.16.0.1"],
     *         "position": 0
     *     },
     *     "field_2": {
     *         "example_values": ["GET", "POST", "PUT"],
     *         "position": 1
     *     },
     *     "field_3": {
     *         "example_values": ["/index.html", "/api/data", "/update"],
     *         "position": 2
     *     }
     * }
     * ```
     */
    review_fields: _zod.z.string()
  })
}).version({
  template: {
    mustache: {
      template: _review_fields_prompt_template.default
    }
  },
  toolChoice: {
    function: 'validate_response_schema'
  },
  tools: {
    validate_response_schema: {
      description: 'Validate the response schema to ensure the output adheres to the defined structure.',
      schema: {
        type: 'object',
        properties: {
          log_source: {
            type: 'string'
          },
          fields: {
            type: 'array',
            items: {
              type: 'object',
              properties: {
                ecs_field: {
                  type: 'string'
                },
                columns: {
                  type: 'array',
                  items: {
                    type: 'string'
                  }
                }
              },
              required: ['ecs_field', 'columns']
            }
          }
        },
        required: ['log_source', 'fields']
      }
    }
  }
}).get();