"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getScopedClient = void 0;
var _columns_from_locator = require("./columns_from_locator");
var _searchsource_from_locator = require("./searchsource_from_locator");
var _title_from_locator = require("./title_from_locator");
var _query_from_locator = require("./query_from_locator");
var _filters_from_locator = require("./filters_from_locator");
var _time_field_name_from_locator = require("./time_field_name_from_locator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getScopedClient = (core, deps) => {
  return {
    asScopedClient: async req => {
      const searchSourceStart = await deps.data.search.searchSource.asScoped(req);
      const savedObjects = core.savedObjects.getScopedClient(req);
      const uiSettings = core.uiSettings.asScopedToClient(savedObjects);
      const services = {
        searchSourceStart,
        savedObjects,
        uiSettings
      };
      return {
        columnsFromLocator: (0, _columns_from_locator.columnsFromLocatorFactory)(services),
        searchSourceFromLocator: (0, _searchsource_from_locator.searchSourceFromLocatorFactory)(services),
        titleFromLocator: (0, _title_from_locator.titleFromLocatorFactory)(services),
        queryFromLocator: (0, _query_from_locator.queryFromLocatorFactory)(services),
        filtersFromLocator: (0, _filters_from_locator.filtersFromLocatorFactory)(services),
        timeFieldNameFromLocator: (0, _time_field_name_from_locator.timeFieldNameFromLocatorFactory)(services)
      };
    }
  };
};
exports.getScopedClient = getScopedClient;