"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDiscoverLocatorParams = void 0;
var _esQuery = require("@kbn/es-query");
var _esqlUtils = require("@kbn/esql-utils");
var _controlsConstants = require("@kbn/controls-constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getDiscoverLocatorParams = api => {
  var _api$savedObjectId$;
  const savedSearch = api.savedSearch$.getValue();
  const query = savedSearch === null || savedSearch === void 0 ? void 0 : savedSearch.searchSource.getField('query');
  const dataView = savedSearch === null || savedSearch === void 0 ? void 0 : savedSearch.searchSource.getField('index');
  const savedObjectId = (_api$savedObjectId$ = api.savedObjectId$) === null || _api$savedObjectId$ === void 0 ? void 0 : _api$savedObjectId$.getValue();
  const locatorParams = savedObjectId ? {
    savedSearchId: savedObjectId
  } : {
    dataViewId: dataView === null || dataView === void 0 ? void 0 : dataView.id,
    dataViewSpec: dataView === null || dataView === void 0 ? void 0 : dataView.toMinimalSpec(),
    esqlControls: getEsqlControls(api.parentApi, query),
    timeRange: savedSearch === null || savedSearch === void 0 ? void 0 : savedSearch.timeRange,
    refreshInterval: savedSearch === null || savedSearch === void 0 ? void 0 : savedSearch.refreshInterval,
    filters: savedSearch === null || savedSearch === void 0 ? void 0 : savedSearch.searchSource.getField('filter'),
    query,
    columns: savedSearch === null || savedSearch === void 0 ? void 0 : savedSearch.columns,
    sort: savedSearch === null || savedSearch === void 0 ? void 0 : savedSearch.sort,
    viewMode: savedSearch === null || savedSearch === void 0 ? void 0 : savedSearch.viewMode,
    hideAggregatedPreview: savedSearch === null || savedSearch === void 0 ? void 0 : savedSearch.hideAggregatedPreview
  };
  return locatorParams;
};
exports.getDiscoverLocatorParams = getDiscoverLocatorParams;
function isApiESQLVariablesCompatible(api) {
  return Boolean(api && (api === null || api === void 0 ? void 0 : api.controlGroupApi$) !== undefined);
}
function getEsqlControls(embeddableParentApi, query) {
  var _controlGroupApi$seri;
  if (!(0, _esQuery.isOfAggregateQueryType)(query)) return;
  if (!isApiESQLVariablesCompatible(embeddableParentApi)) return undefined;
  const controlGroupApi = embeddableParentApi.controlGroupApi$.getValue();
  if (!controlGroupApi) return undefined;
  const serializedState = (_controlGroupApi$seri = controlGroupApi.serializeState) === null || _controlGroupApi$seri === void 0 ? void 0 : _controlGroupApi$seri.call(controlGroupApi);
  if (!serializedState) return undefined;
  const usedVariables = (0, _esqlUtils.getESQLQueryVariables)(query.esql);
  return serializedState.rawState.controls.reduce((acc, control) => {
    if (!control.id) return acc;
    if (control.type !== _controlsConstants.ESQL_CONTROL) return acc; // only include ESQL controls
    if (!control.controlConfig) return acc;
    const variableName = 'variableName' in control.controlConfig && control.controlConfig.variableName;
    if (!variableName) return acc;
    const isUsed = usedVariables.includes(variableName);
    if (!isUsed) return acc;
    return {
      ...acc,
      [control.id]: {
        ...control.controlConfig,
        type: control.type,
        order: control.order
      }
    };
  }, {});
}